

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
[Enum(BlendOnOff)]
_BlendState = {"belnd state", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"blendsrc", FLOAT, "1.0"},
[Enum(BlendFactor)]
_BlendDst = {"blenddst", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "statetest"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGB
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
SamplerState _MainSampler;

v2f vert(appdata v)
{
	v2f o;
	// simple transform
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	// sample the texture
	mainColor = _MainTex.Sample(_MainSampler, i.uv);
}
ENDCG
#END
