local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local apollonode = require "apolloutility.apollonode"
local Object = require "classic"



local BackgroundLoader = {}


--加载mesh
function BackgroundLoader:Initialize()
  self.OnParseBackgroundEvent = nil;
  self.OnReleaseResourceEvent = nil;
  self.OnInitializeEvent = nil;
  --注册监听事件
  self:RegisterEvents();

end

function BackgroundLoader:RegisterEvents()
  self.OnInitializeEvent = utility:CreateInovation(self,self.OnInitialize);
  self.OnParseBackgroundEvent = utility:CreateInovation(self,self.ParseBackground);
  self.OnReleaseResourceEvent = utility:CreateInovation(self,self.ReleaseResource);
  
  beholder.observe(defined.Event.ON_INITIALIZE,self.OnInitializeEvent);
  beholder.observe(defined.Event.ON_RESOURCE_BACKGROUND,self.OnParseBackgroundEvent);
  beholder.observe(defined.Event.ON_RELEASE_RESOURCE,self.OnReleaseResourceEvent);
end

function BackgroundLoader:OnInitialize(a)
  --self:_CreateDefaultBack();
end


function BackgroundLoader:_CreateDefaultBack()
  
end


function BackgroundLoader:ParseBackground(backgroundInfo)
  if backgroundInfo then
    local backType = backgroundInfo.Type;
    local texture = backgroundInfo.Texture;
    local mipmapLevels = backgroundInfo.MipmapLevels;
    
    --普通背景
    if backType == "Normal" then
      self:_CreateNormalBack(texture);
    elseif backType == "CubMap" then
      if mipmapLevels and mipmapLevels > 1 then
        self:_CreateCubMapBackWithMipmap(texture, mipmapLevels);
      else
        self:_CreateCubMapBack(texture);
      end
    end
  end
end


function BackgroundLoader:_CreateNormalBack(texture)
  
  self.quad = apollonode.QuadNode()
  self.quad:SetShadowCaster(false);

  self.quad:CreateResource("comm:documents/material/imageblit.material");
  
  local texturePath = venuscore.IFileSystem:PathAssembly("ress:" .. texture);
  local tex = apolloengine.TextureEntity();
  tex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      texturePath));
  local res = tex:CreateResource();
  self.quad:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,tex);
end


function BackgroundLoader:_PushTextureWithTarget(skybox, target, path)

  skybox:PushMetadata(apolloengine.TextureFileMetadata(
      target,
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, true,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
      path));
end

function BackgroundLoader:_PushTextureWithTargetMipMap(skybox, target, level, path)
  skybox:PushMetadata(apolloengine.TextureFileMetadata(
      target,
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,
      1, true, level,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
      path));
end

function BackgroundLoader:_PushMipmapTextures(textureEntity, texturePath, textureFace, mipmapLevels)
  local texturePathGen = venuscore.IFileSystem:PathAssembly("ress:" .. texturePath)
  for i = 1, mipmapLevels do
    local srcStr = ".png"
    local dstStr = "_"..tostring(i - 1)..".png"
    local curFileName = string.gsub(texturePathGen, srcStr, dstStr)
    self:_PushTextureWithTargetMipMap(textureEntity, textureFace, i-1, curFileName)
  end
end

function BackgroundLoader:_CreateCubMapBackWithMipmap(texture, mipmapLevels)
  apolloengine.ShaderEntity.SKY_BOX = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SKY_BOX");
  local skybox = apolloengine.TextureEntity();
  
  self:_PushMipmapTextures(skybox, texture.front, apolloengine.TextureEntity.TT_TEXTURECUBE_FRONT, mipmapLevels);
  self:_PushMipmapTextures(skybox, texture.back, apolloengine.TextureEntity.TT_TEXTURECUBE_BACK, mipmapLevels);
  self:_PushMipmapTextures(skybox, texture.top, apolloengine.TextureEntity.TT_TEXTURECUBE_TOP, mipmapLevels);
  self:_PushMipmapTextures(skybox, texture.bottom, apolloengine.TextureEntity.TT_TEXTURECUBE_BOTTOM, mipmapLevels);
  self:_PushMipmapTextures(skybox, texture.left, apolloengine.TextureEntity.TT_TEXTURECUBE_LEFT, mipmapLevels);
  self:_PushMipmapTextures(skybox, texture.right, apolloengine.TextureEntity.TT_TEXTURECUBE_RIGHT, mipmapLevels);
  
  skybox:CreateResource();
  apolloengine.IMaterialSystem:SetGlobalParameter(apolloengine.ShaderEntity.SKY_BOX,skybox);
end

function BackgroundLoader:_CreateCubMapBack(texture)
  
  apolloengine.ShaderEntity.SKY_BOX = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"SKY_BOX");
  local skybox = apolloengine.TextureEntity();
  
  local texturePath_front = venuscore.IFileSystem:PathAssembly("ress:" .. texture.front);
  local texturePath_back = venuscore.IFileSystem:PathAssembly("ress:" .. texture.back);
  local texturePath_top = venuscore.IFileSystem:PathAssembly("ress:" .. texture.top);
  local texturePath_bottom = venuscore.IFileSystem:PathAssembly("ress:" .. texture.bottom);
  local texturePath_left = venuscore.IFileSystem:PathAssembly("ress:" .. texture.left);
  local texturePath_right = venuscore.IFileSystem:PathAssembly("ress:" .. texture.right);

  self:_PushTextureWithTarget(skybox, apolloengine.TextureEntity.TT_TEXTURECUBE_FRONT, texturePath_front);
  self:_PushTextureWithTarget(skybox, apolloengine.TextureEntity.TT_TEXTURECUBE_BACK, texturePath_back);
  self:_PushTextureWithTarget(skybox, apolloengine.TextureEntity.TT_TEXTURECUBE_TOP, texturePath_top);
  self:_PushTextureWithTarget(skybox, apolloengine.TextureEntity.TT_TEXTURECUBE_BOTTOM, texturePath_bottom);
  self:_PushTextureWithTarget(skybox, apolloengine.TextureEntity.TT_TEXTURECUBE_LEFT, texturePath_left);
  self:_PushTextureWithTarget(skybox, apolloengine.TextureEntity.TT_TEXTURECUBE_RIGHT, texturePath_right);
  
  skybox:CreateResource();
  apolloengine.IMaterialSystem:SetGlobalParameter(apolloengine.ShaderEntity.SKY_BOX,skybox);
  
end

function BackgroundLoader:ReleaseResource()
  self.OnParseBackgroundEvent = nil;
  self.OnReleaseResourceEvent = nil;
  self.quad = nil;
end


BackgroundLoader:Initialize();

return BackgroundLoader;


