local apolloengine = require "apolloengine"
local venuscore = require "venuscore"

local utils = {}

function utils:GetExtension(filename)
    return filename:match("^.+(%..+)$")
end

function utils:IsImage(filename)
  local file_ext = self:GetExtension(filename)
  return file_ext == ".png" or file_ext == ".jpeg" or file_ext == ".jpg"
end

function utils:LoadTexture(texpath)
  local tex = apolloengine.TextureEntity();
  tex:PushMetadata(apolloengine.TextureFileMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_NEAREST,
      apolloengine.TextureEntity.TF_NEAREST,
      texpath));
  tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  tex:CreateResource();
  return tex;
end

return utils