local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local MaskSequenceBase = require "photomood.mask_sequence_base"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "photomood.defined"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
--local filterqueue = require "apolloutility.filterqueue" 
local Object = require "classic"
local Cover = require "photomood.cover"



local MaskSequence = MaskSequenceBase:extend();

function MaskSequence:new(customID,channel, materialname,material_list, track_list,maincamera,videowidth,videoheight,renderorder,fixedresolution)
  MaskSequence.super.new(self,customID,channel, materialname, material_list,track_list,maincamera,videowidth,videoheight,renderorder,fixedresolution);
  --windows mask 测试  
  self.mask_imagereader = asynctexture();
  self.mask_imagereader:SetKeepSource(false);
  self.mask_imagereader:SequentialLoad(20, true, 1, biugodefined.windows_mask_sequence_path .. "/" .. biugodefined.windows_mask_sequence_name, nil);
  self.mask_imagereader:Preloading();
  
  local custom_texture = apolloengine.TextureEntity();
  custom_texture:PushMetadata(
    apolloengine.TextureFileMetadata(biugodefined.windows_custom_texture_path .. biugodefined.windows_custom_texture_name));
  custom_texture:CreateResource();
  self.custom_texture = custom_texture;
  self.custom_texture_size = custom_texture:GetSize();  --对于文字需要简单的缩放排版

  
end

function MaskSequence:Update(timespan)
  
  self:SetShow(true); --开启绘制
  
  local rgb, alpha, frame, isplaying = 0;
  rgb, frame, alpha, isplaying = self.mask_imagereader:Update(timespan);
  --LOG("Mask FrameIndex is: " .. tostring(frame));
  if rgb and isplaying then
    self.mask_texture = rgb;
  else
    self.mask_textrue = self.empty_mask_texture;
  end
  --Cover:Update(self.custom_texture_size);
  MaskSequence.super.Update(self,frame,false);
end

function MaskSequence:SetMaskTexture(id,texid,size)
end


return MaskSequence;


