local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local defined = require "apolloutility.defiend"
local haircolordefined = require "facecute.haircolor.haircolordefined"
local HistoricalFrameBase = require "apolloutility.basehistoricalframe"
local renderqueue = require "apolloutility.renderqueue"
require "utility"

local historicalframe = HistoricalFrameBase:extend();
function historicalframe:Initialize(layerId,num,sequence,deley,material,isNeedHair)
  historicalframe.super.new(self,layerId,num,sequence,material);
  self.timedelay = deley;  --历史帧延时
  self.isNeedHair = isNeedHair;
  self.hairmask = nil;
  self.num = num;
  self.layerId = layerId;
end


function historicalframe:Update()
  local prevTex = renderqueue:GetLinkedTexture(self.layerId)
  self:SetVideoTexture(prevTex);
 
  if self.isNeedHair == true then 
    self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_HAIR_MASK, self.hairmask);
  end
  historicalframe.super.Update(self);
  
  if self.isGetEnoughFrame == true then
    self.outtex = {}
    for i = 2,self.num,1 do
      table.insert(self.outtex,self.texqueue[i]);
    end
    table.insert(self.outtex,self.texqueue[1]);
    return self.outtex;
  else
    return nil;
  end

end

function historicalframe:SetHairMask(hairmask)
  self.hairmask = hairmask;
end


function historicalframe:Clear()
  historicalframe.super.Clear(self);
  self.hairmask  = nil;
end


return historicalframe;
