local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local defined = require "apolloutility.defiend"
local Keyboard = require "apolloengine.inputdelegate.keyboarddelegate"

local KeyBoardBehavior = venuscore.VenusBehavior:extend("KeyBoardBehavior"); 

local STATE_STOP = 0;
local STATE_PLAY = 1;

function KeyBoardBehavior:OnKey(key,status)
  --Q
  if key==34 and status==3 then
    if self.ChangeClothAni and self.ChangeClothState ~= STATE_PLAY then
      local renderCmp = self.ChangeClothAni:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
      renderCmp:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      self.ChangeClothAni:Play();
      self.ChangeClothState = STATE_PLAY;
      self.ChangeClothTimer = 0;
      --self.ChangeClothRender.
      local matpath = "test:kiki/mat/cloth.mat";
      if self.Cloth==1 then
        matpath = "test:kiki/mat/cloth2.mat";
        self.Cloth = 2;
      elseif self.Cloth == 2 then
        matpath = "test:kiki/mat/cloth3.mat";
        self.Cloth = 3;
      else
        self.Cloth = 1;
      end
      local materialEntity = apolloengine.MaterialEntity();
      local meta = apolloengine.MaterialMetadata(matpath);
      materialEntity:PushMetadata(meta);
      materialEntity:CreateResource();
      self.ChangeClothRender:ChangeMaterial(materialEntity, 1);
      
    end
  end
end

function KeyBoardBehavior:new()
  self.ChangeClothAni = nil;
  self.ChangeClothState = STATE_STOP; 
  self.ChangeClothTimer = -1;
  self.ChangeClothRender = nil;
  self.Cloth = 1;
end

function  KeyBoardBehavior:_OnStart()
  self.keyboard = function (key,status) self:OnKey(key,status) end
  Keyboard:AddCallback(  self.keyboard);
end

function  KeyBoardBehavior:_OnUpdate()
  local def = self:Timespan();
  if self.ChangeClothTimer >=0 then
    self.ChangeClothTimer = self.ChangeClothTimer+def;
    if self.ChangeClothTimer>3 then
      self.ChangeClothTimer = -1;
      local renderCmp = self.ChangeClothAni:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
      renderCmp:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
      self.ChangeClothState = STATE_STOP;
    end
  end
end

function KeyBoardBehavior:Timespan()
  
  if self.begintime== nil then 
    self.begintime = venuscore.ITimerSystem:GetTimevalue();
  end
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;

 
  return def;
end


KeyBoardBehavior:MemberRegister("ChangeClothAni",
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.FrameAnimationComponent:RTTI()
));

KeyBoardBehavior:MemberRegister("ChangeClothRender",
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.RenderComponent:RTTI()
));

return KeyBoardBehavior;