local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local FixedBGPartBehavior = venuscore.VenusBehavior:extend("FixedBGPartBehavior");

function FixedBGPartBehavior:new()
  self.rootNode = nil;
  self.trans = nil;
  self.rect = mathfunction.vector2(0,0);
  self.lastSize = mathfunction.vector2(0,0);
  self.fixedUV = {{0,0},{0,100},{100,0},{100,100}};
end

function FixedBGPartBehavior:_OnAwake()
  self.rootNode = self.Node:GetRoot();
  self.trans = self.Node:GetComponent(apolloengine.Node.CT_TRANSFORM);
  self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
  self.vertexstream = apolloengine.VertexStream();
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
          apolloengine.VertexBufferEntity.DT_FLOAT,
          apolloengine.VertexBufferEntity.DT_HALF_FLOAT, 2);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
          apolloengine.VertexBufferEntity.DT_FLOAT,
          apolloengine.VertexBufferEntity.DT_HALF_FLOAT, 2);
  --创建索引流
  self.indicesstream = apolloengine.IndicesStream();
  self.indicesstream:SetIndicesType(
          apolloengine.IndicesBufferEntity.IT_UINT16);

  -- lefttop
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(0,0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));

  -- leftbottom
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(0,0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 100));

  -- righttop
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(0,0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(100, 0));

  -- rightbottom
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(0,0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(100, 100));

  -- 顶点数据
  self.indicesstream:PushIndicesData(0);
  self.indicesstream:PushIndicesData(1);
  self.indicesstream:PushIndicesData(2);
  self.indicesstream:PushIndicesData(2);
  self.indicesstream:PushIndicesData(1);
  self.indicesstream:PushIndicesData(3);
end

function FixedBGPartBehavior:_OnStart()
  self.rootNode = self.Node:GetRoot();
  self:ChangeSize(self.rect);
  self.lastSize:Set(self.rect:x(),self.rect:y());
end

function FixedBGPartBehavior:_OnUpdate(def)
  if _KRATOSEDITOR then
    if self.rect ~= self.lastSize then
      self:ChangeSize(self.rect);
      self.lastSize:Set(self.rect:x(),self.rect:y());
    end
  end
end


function FixedBGPartBehavior:ChangeSize(size)
  local width = size:x();
  local height = size:y();
  local points_table =
  {
    {
      -width/2,
      height/2,
    },
    {
      -width/2,
      -height/2,
    },
    {
      width/2,
      height/2,
    },
    {
      width/2,
      -height/2,
    },
  };
  local newpoint =  mathfunction.vector2(0, 0);
  local posIndex = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  local uvIndex = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0);
  for i=1, #points_table do
    local point = points_table[i];
    newpoint:Set(point[1], point[2]);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
            posIndex,
            i,
            newpoint);
  end
  local newuv =  mathfunction.vector2(0, 0);
  local uv_table = self.fixedUV;
  for i=1, #uv_table do
    local uv = uv_table[i];
    newuv:Set(uv[1], uv[2]);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
            uvIndex,
            i,
            newuv);
  end
  self.vertexstream:SetReflushInterval(1, 4);
  self.render:ChangeVertexBuffer(self.vertexstream);
  self.render:ChangeIndexBuffer(self.indicesstream);
end

function FixedBGPartBehavior:GetMaxRect()
  return self.rect;
end

FixedBGPartBehavior:MemberRegister("rect");

return FixedBGPartBehavior;