local venusjson = require "venusjson"
local venuscore = require "venuscore"
local object = require "classic"
local torch = require "torch"
local mathfunction = require "mathfunction"

local Proj = require "torchutility.cameraviewproj"
local Robustifier = require "torchutility.robustifier"
local Substract =  require "torchutility.substract"
local SignedSqrt =  require "torchutility.signedsqrt"
local AutoTensor =  require "torchutility.autotensor"
local MixGauss = require "torchutility.mixgauss"
local SubTensor = require "torchutility.subtensor"
local TransformMat = require "torchutility.transformmat"
local ToPoseList =  require "torchutility.toposelist"
local Add =  require "torchutility.add"
local PoseExp =  require "torchutility.poseexp"
local Length =  require "torchutility.Length"
local Power =  require "torchutility.power"
local Dot =  require "torchutility.multiply"

local dogleg = require "torchutility.dogleg"

local CameraMinimize = {}

function CameraMinimize:Initialize(focallength, cx, cy)
  self.focallength = focallength
  self.cx = cx
  self.cy = cy
  self.preroot = nil;
  
end

function CameraMinimize:Minimise(transform,pos3d,pos2d)

  local  transt = torch.Tensor(1,3);
  transt[1][1] = transform[1];
  transt[1][2] = transform[2];
  transt[1][3] = transform[3];
  local  trans = AutoTensor();
  trans:VFromTorch(transt)
  
  local  extendmat = AutoTensor();
  extendmat:VFromTorch(torch.Tensor(15,1):fill(1));
  
  local finaltrans = Dot(extendmat,trans);
  local position3d = AutoTensor(pos3d);
  
  local position2d = AutoTensor(pos2d);

  local proj3d = Add(position3d,finaltrans);
  local proj2d = Proj(self.focallength,self.focallength,self.cx,self.cy,proj3d);
  
  
  
  local Sub = Substract(proj2d,position2d);
  local leastsquares = Power(Sub, 2);
  

  
  local funcs = {}
  funcs.proj = {}
  funcs.proj.fx = function (x)
    trans:V(x);
    return leastsquares:R();
  end
  
  funcs.proj.dx = function (x)
    trans:V(x);
    return leastsquares:D2(trans);
  end
  
  if self.preroot~=nil then
    
    local  pretranst = torch.Tensor(1,3);
    pretranst[1][1] =  self.preroot[1];
    pretranst[1][2] =  self.preroot[2];
    pretranst[1][3] =  self.preroot[3];
    local  pretrans = AutoTensor();
    pretrans:VFromTorch(pretranst);
    LOG(pretrans);
    local Sub2 = Substract(trans,pretrans);
    local leastsquares2 = Power(Sub2, 2);
    
    funcs.move = {}
    funcs.move.fx = function (x)
      trans:V(x);
      return leastsquares2:R()*0.001;
    end
    
    funcs.move.dx = function (x)
      trans:V(x);
      return leastsquares2:D2(trans)*0.001;
    end
    
  end
  
  
  local config =  {
    maxiter = 100,
    e_3 = 0.01,
  }
 
  dogleg(funcs, trans:R(), config); 
  self.preroot = trans:R()[1];
  return trans:R();
  
end

return CameraMinimize;