local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local pnpestimates = require "pnpestimates"
local videodecet = require "videodecet"


local epnp = {}

epnp.male = 1;
epnp.female = 2;

--初始化
function epnp:Initialize(gender, camera)
  self.postureestimates = {}
  self.fullpnp = pnpestimates.EPnPShell();
  self.transpnp = pnpestimates.TranslationShell();
  local resolution = apolloengine.Framework:GetResolution();
  local max = math.max(resolution:x(), resolution:y());
  self.fullpnp:SetIntrinsic(max, max, 0.5*resolution:x(), 0.5*resolution:y());
  self.transpnp:SetIntrinsic(max, max, 0.5*resolution:x(), 0.5*resolution:y());
  
  --模型选点
  local vec3array = mathfunction.vector3array();
  if gender == epnp.male then
    vec3array:PushBack(mathfunction.vector3(0.1161921, 1.425116, 0.0009757746));--m_avg_L_Collar hack
    vec3array:PushBack(mathfunction.vector3(-0.11846403, 1.423589, -0.003833437));--m_avg_R_Collar hack
    vec3array:PushBack(mathfunction.vector3(0.05640767, 0.8904438, 0.01091971));--m_avg_L_Hip
    vec3array:PushBack(mathfunction.vector3(-0.06248341, 0.8822106, 0.01504126));--m_avg_R_Hip
  elseif gender == epnp.female then
    vec3array:PushBack(mathfunction.vector3(0.1175219, 1.307082, -0.005084647));--m_avg_L_Collar
    vec3array:PushBack(mathfunction.vector3(-0.0748092, 1.304908, -0.01002048));--m_avg_R_Collar
    vec3array:PushBack(mathfunction.vector3(0.07048488, 0.8197308, 0.01977493));--m_avg_L_Hip
    vec3array:PushBack(mathfunction.vector3(-0.06988832, 0.8203542, 0.02302543));--m_avg_R_Hip
  else
    error("unkown gender");
  end  
  self.fullpnp:SetModelPoints(vec3array);
  self.transpnp:SetModelPoints(vec3array);
  
  --初始化屏幕坐标点数组备用
  self.screenpos = mathfunction.vector2array();
  self.screenpos:Resize(4);
end

function epnp:Update(p, y, r)
  local point2ds = videodecet:GetBodyPoints();--像素坐标
  local videosize = videodecet:GetVideoSize();
  
  local body = {
    l_shoulder = {point2ds[7],point2ds[8]},
    r_shoulder = {point2ds[5],point2ds[6]},
    l_hip = {point2ds[19],point2ds[20]},
    r_hip = {point2ds[17],point2ds[18]},
  };
  
  local realres = apolloengine.Framework:GetResolution();
  local s_x = realres:x() / videosize[1];
  local s_y = realres:y() / videosize[2];
  
  for name, value in pairs(body) do
    body[name] = {
      value[1] * s_x,
      value[2] * s_y}
  end
  
  self.postureestimates = {};
  local vec2 = mathfunction.vector2();
  
  vec2:Set(body.l_shoulder[1], body.l_shoulder[2]);
  self.screenpos:Set(1, vec2);
  
  vec2:Set(body.r_shoulder[1], body.r_shoulder[2]);
  self.screenpos:Set(2, vec2);
  
  vec2:Set(body.l_hip[1], body.l_hip[2]);
  self.screenpos:Set(3, vec2);
  
  vec2:Set(body.r_hip[1], body.r_hip[2]);
  self.screenpos:Set(4, vec2);
  
  local res;
  if p and y and r then
    self.transpnp:Estimates(p, y, r, self.screenpos);  
    res = {
      position = self.transpnp:GetTransform();
      rotation = self.transpnp:GetRotation();
    }
  else
    self.fullpnp:Estimates(self.screenpos);  
    res = {
      position = self.fullpnp:GetTransform();
      rotation = self.fullpnp:GetRotation();
    }
  end  
  return res, body;
end

return epnp;