require('mobdebug').start()
local _DEBUG = true;
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "venusdebug"
require "utility"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local main = {}

function main:Timespan()
	local now = venuscore.ITimerSystem:GetTimevalue();
	local def = now - self.begintime;
	self.begintime = now;
	self.cumtime = self.cumtime + def;
	self.fps = self.fps + 1;

	if self.cumtime > 5 then
		local fps = self.fps / self.cumtime;
		self.fps = 0;
		self.cumtime = 0;
		LOG("FPS "..fps);
	end
	return def;
end

function main:CreateCameras(near, far, pos, lookat, up)
	self.mainCamera = apollonode.CameraNode();--新建相摄像机
	self.mainCamera:CreatePerspectiveProjection(near, far);--设置摄像机
	self.mainCamera:LookAt(pos, lookat, up);
	self.mainCamera:Recalculate();--手动更新矩阵
	self.mainCamera:Activate();--激活主摄像机
end

function main:Initialize()
	_COROUTINES_ON();

	self.rotation = mathfunction.Quaternion();
	self.begintime = venuscore.ITimerSystem:GetTimevalue();
	self.cumtime = 0;
	self.fps = 0;

	self:CreateCameras(1, 1000,
		mathfunction.vector3(0, 5, 10),
		mathfunction.vector3(0, 0, 0),
		mathfunction.vector3(0, 1, 0));
	self.lightnode = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
	self.lightnode:SetColor(
		mathfunction.vector3(1, 0, 1));
	self.lightnode:SetLocalDirection(
		mathfunction.vector3(0.2, -1, -0.3));
	apolloengine.IPhysicSystem:SetGlobalScale(1);

	self.renders = {}
	self.nodes = {}
	self.trans = {}
	self.rigids = {}

	self:InitPosBind();

	apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");
	apolloengine.IPhysicSystem:SetGravity(mathfunction.vector3(0, -10, 0));
	self:Update();
	LOG("initialize done");
	_COROUTINES_OFF();
	return true;
end

function main:TestCapsule()
	local node = apolloengine.Node();
	local render = node:CreateComponent(apolloengine.Node.CT_RENDER);
	local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
	local rigid = node:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
	trans:SetLocalPosition(mathfunction.vector3(0, 4, 0));
	rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CAPSULE);
	shape = rigid:GetCollisionShape();
	shape.CapsuleAxis = 1;
	shape.CapsuleHeight = 0.3;
	shape.CapsuleRadius = 0.1;
	--rigid:SetKinematic(true);
	shape.CapsuleAxis = 2;
	table.insert(self.nodes, node);
	table.insert(self.trans, trans);
	table.insert(self.rigids, rigid);
	table.insert(self.renders, render);
	rigid:EnableDebug();
	return rigid;
end

function main:TestBox()
	local node = apolloengine.Node();
	local render = node:CreateComponent(apolloengine.Node.CT_RENDER);
	local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
	local rigid = node:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
	trans:SetLocalPosition(mathfunction.vector3(0, -5, 0));
	rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_BOX);
	shape = rigid:GetCollisionShape();
	shape.BoxHalfExtent = mathfunction.vector3(2, 2, 2);
	rigid:SetKinematic(true);
	table.insert(self.nodes, node);
	table.insert(self.trans, trans);
	table.insert(self.rigids, rigid);
	table.insert(self.renders, render);
	rigid:EnableDebug();
	return rigid;
end


function main:TestBox2()
	local node = apolloengine.Node();
	local render = node:CreateComponent(apolloengine.Node.CT_RENDER);
	local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
	local rigid = node:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
	trans:SetLocalPosition(mathfunction.vector3(0, 2, 0));
	rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_BOX);
	shape = rigid:GetCollisionShape();
	--shape.BoxHalfExtent = mathfunction.vector3(0.2, 0.2, 0.2);

	table.insert(self.nodes, node);
	table.insert(self.trans, trans);
	table.insert(self.rigids, rigid);
	table.insert(self.renders, render);
	rigid:EnableDebug();
	return rigid;
end

function main:TestShpere()
	local node = apolloengine.Node();
	local render = node:CreateComponent(apolloengine.Node.CT_RENDER);
	local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
	local rigid = node:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
	trans:SetLocalPosition(mathfunction.vector3(0, 3, 0));
	rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_SPHERE);
	shape = rigid:GetCollisionShape();
	shape.SphereRadius = 0.3;
	--rigid:SetKinematic(true);
	table.insert(self.nodes, node);
	table.insert(self.trans, trans);
	table.insert(self.rigids, rigid);
	table.insert(self.renders, render);
	rigid:EnableDebug();
	return rigid;
end

function main:TestCylinder()
	local node = apolloengine.Node();
	local render = node:CreateComponent(apolloengine.Node.CT_RENDER);
	local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
	local rigid = node:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
	trans:SetLocalPosition(mathfunction.vector3(0.5, 2, 0));
	rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CYLINDER);
	shape = rigid:GetCollisionShape();
	shape.CylinderHalfExtent = mathfunction.vector3(0.2, 0.2, 0.2);
	--rigid:SetKinematic(true);
	table.insert(self.nodes, node);
	table.insert(self.trans, trans);
	table.insert(self.rigids, rigid);
	table.insert(self.renders, render);
	rigid:EnableDebug();
	return rigid;
end

function main:TestCone()
	local node = apolloengine.Node();
	local render = node:CreateComponent(apolloengine.Node.CT_RENDER);
	local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
	local rigid = node:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
	trans:SetLocalPosition(mathfunction.vector3(0, 1, 0));
	rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_CONE);
	shape = rigid:GetCollisionShape();
	shape.ConeRadius = 0.1;
	shape.ConeHeight = 0.3;
	--rigid:SetKinematic(true);
	table.insert(self.nodes, node);
	table.insert(self.trans, trans);
	table.insert(self.rigids, rigid);
	table.insert(self.renders, render);
	rigid:EnableDebug();
	return rigid;
end


function main:InitPosBind()
	self.capsule = self:TestCapsule();
	self.box = self:TestBox();
	self.sphere = self:TestShpere();
	self.cylinder = self:TestCylinder();
	self.cone = self:TestCone();
	self.box2 = self:TestBox2();
end

function main:Update()
	local def = self:Timespan();
	apolloengine.IPhysicSystem:Update(def, 10, 1.0/60.0);
end

function main:Ontime()
    _COROUTINES_ON();
    self.gestureanimation:Update();
    _COROUTINES_OFF();
end

function main:OnTouch(touchinfo)
    _COROUTINES_ON();
    local vec2 = touchinfo:GetTouchPoint(1);
    self.gestureanimation:SetSimulateActionPoint(vec2);
    _COROUTINES_OFF();
  
end

function main:Abort()
    venuscore.ITimerSystem:UnregisterTimer(self._Agent, "Ontime");
    apolloengine.Framework:RemoveTouchCallback(self._Agent, "OnTouch");
    apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "Update");
    venuscore.IApplication:Abort();
end


return main
