#SHADER_DEFINE ShineVolumnLightVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    
#END_CODE
#END_DEFINE

#SHADER_DEFINE ShineVolumnLightFragment

	FUNCTION_INPUT = 
	{
        { ATTRIBUTE_COORDNATE0,		       HIGH,	 VEC2,		      	"texture_coord"},
        { FRAME_TEXTURE,	               NONE,	 TEXTURE2D,		  	"frame_texture"},
        { BRIGHT_TEXTURE,                  NONE,     TEXTURE2D,         "bright_texture"},
        { UNIFORM_LIGHT_COLOR,             HIGH,     VEC3,              "light_color"},
        { SAMPLES,                         MEDIUM,   FLOAT,             "float_samples"},
        { STEP,                            HIGH,     FLOAT,             "step"},
    }

#SHADER_CODE

	int samples = int(float_samples);
    // Screen coordinates.
    vec2 uv = texture_coord;//fragCoord.xy / iResolution.xy;

    float decay = 0.7; 
    float density = 1.0; 
    float weight = 0.6; 
    //const float SAMPLES = 30.0;
    // vec3 lightColor = vec3(1.0, 0.6, 0.6)*0.5;
	// const float step = 0.005;

	vec2 tuv =  uv - vec2(0.5);
	float dis = length(tuv);
	
    vec2 dTuv = dis > float_samples * step ? normalize(tuv) * step: tuv / float_samples;
    float sum_brightness = 0.0;
 
	float delta_step = 1.0 / float_samples;
	float cur_dis = 1.0;
	for(int i= 0; i < samples; i++)
	{
        uv -= dTuv;
        sum_brightness += texture2D(bright_texture, uv).r  * 0.05 * cur_dis * cur_dis;
		cur_dis -= delta_step;
    }

	//sumBrightness = min(sumBrightness, 0.7);
	//sumBrightness *= (1.0 - dis / 0.7)*(1.0 - dis / 0.7);
	vec3 rgb = texture2D(frame_texture, texture_coord).xyz;
	vec3 res_color = rgb + light_color * sum_brightness;
	gl_FragColor = vec4(res_color, 1.0);
	
#END_CODE
#END_DEFINE