
#DEFPARAMS
HISTORICAL_FRAME1 = { "Frame Tex1", TEXTURE2D, "white" },
HISTORICAL_FRAME2 = { "Frame Tex2", TEXTURE2D, "white" },
HISTORICAL_FRAME3 = { "Frame Tex3", TEXTURE2D, "white" },
HISTORICAL_FRAME4 = { "Frame Tex4", TEXTURE2D, "white" },
INTERLACE_OFFSET_TEX = { "Interlace Tex", TEXTURE2D, "white" },
FRAME_SIZE = { "Frame size", FLOAT, "0.0"},
CUR_FRAME_ID = { "Cur FrameID", FLOAT, "0.0"},
ROW_FRAME_NUM_PER_TEX = { "Row Fame Num", FLOAT, "1.0"},
COL_FRAME_NUM_PER_TEX = { "Col Frame Num", FLOAT, "1.0"},
INTERLACE_MODE = { "Interlace Mode", FLOAT, "0.0"},
TIME_FACTOR = { "Time Factor", FLOAT, "0.0"},
WAVE_FACTOR = { "Wave Factor", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "Interlace"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D HISTORICAL_FRAME1;
Texture2D HISTORICAL_FRAME2;
Texture2D HISTORICAL_FRAME3;
Texture2D HISTORICAL_FRAME4;
Texture2D INTERLACE_OFFSET_TEX;
SamplerState FRAME_Sampler1;
SamplerState FRAME_Sampler2;
SamplerState FRAME_Sampler3;
SamplerState FRAME_Sampler4;
SamplerState INTERLACE_OFFSET_Sampler;
float FRAME_SIZE;
float CUR_FRAME_ID;
float ROW_FRAME_NUM_PER_TEX;
float COL_FRAME_NUM_PER_TEX;
float INTERLACE_MODE;
float TIME_FACTOR;
float WAVE_FACTOR;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float customMod(float number, float denom)
{
  float tfactor = number / denom;
  float res = frac(tfactor) * denom;
  if(res < 0)
  {
    res += denom;
  }
  return res;
}


void frag(in v2f i, out float4 mainColor : SV_Target0)
{
   float TWO_PI = 2.0 * 3.1415926;    

    int iRowFrameNumPerTex = int(ROW_FRAME_NUM_PER_TEX);
    int iColFrameNumPerTex = int(COL_FRAME_NUM_PER_TEX);

    int FRAME_NUM_PER_TEX  = iRowFrameNumPerTex * iColFrameNumPerTex;
    
    float ratio = 0.0;
    float sin_pos = sin(TWO_PI * (i.uv.x + i.uv.y + TIME_FACTOR));
    float sin_t  = sin(TWO_PI * TIME_FACTOR);
    
    if(INTERLACE_MODE > 0.0)
    {
        ratio = i.uv.y + 0.1 * WAVE_FACTOR * (0.5 * sin_t + sin_t * sin_t) *
                (i.uv.x * i.uv.x + 0.5 * i.uv.x) * sin_pos * sin_pos;
    }
    else
    {       
        ratio = i.uv.x + 0.1 * WAVE_FACTOR * (0.5 * sin_t + sin_t * sin_t) *
                (i.uv.y * i.uv.y + 0.5 * i.uv.y) * sin_pos * sin_pos;
    }
    
    int frame_offset = int(255.0 * INTERLACE_OFFSET_TEX.Sample(INTERLACE_OFFSET_Sampler, float2(ratio, 0.0)).r);

    int a = int(CUR_FRAME_ID) - frame_offset + int(FRAME_SIZE);
    int b = int(FRAME_SIZE);
    // NOTE(Wu Teng): a -b * (a / b) causes frame_id to exceed in_FrameSize, I don't know why.
    //                but mod is ok
    //int frame_id = a - b * (a / b);
    int frame_id =  int(customMod(int(CUR_FRAME_ID) - frame_offset, int(FRAME_SIZE)));

    int tex_id         = frame_id / FRAME_NUM_PER_TEX;
    int local_frame_id = frame_id - FRAME_NUM_PER_TEX * tex_id;
    
    float x_scale = 1.0 / iRowFrameNumPerTex;
    float y_scale = 1.0 / iColFrameNumPerTex;

    int   row_id      = local_frame_id / iRowFrameNumPerTex;
    float tex_x_start = x_scale * float(local_frame_id - iRowFrameNumPerTex * row_id);
    float tex_y_start = y_scale * float(iColFrameNumPerTex - 1 - row_id);

    float2 tex_pos = float2(tex_x_start, tex_y_start) + float2(x_scale, y_scale) * i.uv;
    
    float3 rgb = float3(0.0, 0.0, 0.0);
    if (tex_id == 0)
        rgb = HISTORICAL_FRAME1.Sample(FRAME_Sampler1, tex_pos).rgb;
    else if (tex_id == 1)
        rgb = HISTORICAL_FRAME2.Sample(FRAME_Sampler2, tex_pos).rgb;
    else if (tex_id == 2)
        rgb = HISTORICAL_FRAME3.Sample(FRAME_Sampler3, tex_pos).rgb;
    else if (tex_id == 3)
        rgb = HISTORICAL_FRAME4.Sample(FRAME_Sampler4, tex_pos).rgb;
    
    mainColor = float4(rgb, 1.0);
}
ENDCG
#END
