local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local comic = {}



comic.Cartoon = 0;
comic.commonQuad = 0;
comic.Queue = 320;

--效果参数--
--参数1：前置LUT图,512*512
comic.preImagePath = "ress:filter/resource/lut_pre.png";
--参数2：LUT图，256*16
comic.imagePath = "ress:filter/resource/lut.png";
--参数3：饱和度,取值0 ~ 1.0，值越小效果越强，1.0时饱和度不变
comic.saturation = 1.0;
--参数4：光滑度,取值0.0~3.0,值越小越平滑、细节越少，值越大褶皱感越强，默认取1.0
comic.smooth = 1.0;
--参数5：色阶（颜色分层数），建议范围2.0~16.0, 默认取8.0，值越大色块越多
comic.uLop = 8.0;
--效果参数结束--

function comic:Initialize(host, size)
    --local imagePath = "ress:filter/resource/lut.png";
    
    self.luttex = apolloengine.TextureEntity();
    self.luttex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        comic.imagePath));
    self.luttex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    self.luttex:CreateResource();

	self.preluttex = apolloengine.TextureEntity();
    self.preluttex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        comic.preImagePath));
    self.preluttex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
    self.preluttex:CreateResource();

    self.UNIFORM_uGa = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uGa");
    self.UNIFORM_uHiu = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uHiu");
    self.UNIFORM_uVer = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uVer");
    self.UNIFORM_uOs = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uOs");   
    self.UNIFORM_uHiu = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uHiu");
    self.UNIFORM_uJhi = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uJhi"); 
    self.UNIFORM_uKj = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uKj"); 
    self.UNIFORM_uTau = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uTau"); 
    self.UNIFORM_uS = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uS"); 
    self.UNIFORM_uOin = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uOin"); 
    self.UNIFORM_uEfa = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uEfa");
    self.UNIFORM_uWad = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uWad");
    self.UNIFORM_uEds = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uEds");
    self.UNIFORM_uLop = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uLop");
        

    self.TEXTURE_Lab = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_Lab");
    self.TEXTURE_uLut = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_uLut");
    self.TEXTURE_Outline = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_Outline");
    self.TEXTURE_uDab = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_uDab");
    self.TEXTURE_uBwm = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_uBwm");
    self.TEXTURE_uHam = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_uHam");
    self.TEXTURE_uTua = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "TEXTURE_uTua");    
		
	self.UNIFORM_uSaturantion = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uSaturantion");	
		
	self.UNIFORM_uSmooth = apolloengine.IMaterialSystem:NewParameterSlot(
        apolloengine.ShaderEntity.UNIFORM,
        "UNIFORM_uSmooth");
    
    self.commonQuad = host:CreateRenderObject();
      
    local pathlab = venuscore.IFileSystem:PathAssembly("docs:/material/labcolor.material");  
    --self.labcolor = host:CreateRenderObject(pathlab);
    self.labcolor = host:CreateMaterial(pathlab);   

    local pathdirmap = venuscore.IFileSystem:PathAssembly("docs:/material/dirmap.material");  
    --self.dirmap = host:CreateRenderObject(pathdirmap);
    self.dirmap = host:CreateMaterial(pathdirmap);

    local pathdirblur = venuscore.IFileSystem:PathAssembly("docs:/material/dirblur.material");  
    --self.dirblur = host:CreateRenderObject(pathdirblur);
    self.dirblur = host:CreateMaterial(pathdirblur);

    local pathdirfinal = venuscore.IFileSystem:PathAssembly("docs:/material/dirfinal.material");  
    --self.dirfinal = host:CreateRenderObject(pathdirfinal);
    self.dirfinal = host:CreateMaterial(pathdirfinal);

    local pathdisgauss = venuscore.IFileSystem:PathAssembly("docs:/material/disgauss.material");  
    --self.disguass = host:CreateRenderObject(pathdisgauss);
    self.disguass = host:CreateMaterial(pathdisgauss);

    local pathoutline1 = venuscore.IFileSystem:PathAssembly("docs:/material/outline1.material");  
    --self.outline1 = host:CreateRenderObject(pathoutline1);
    self.outline1 = host:CreateMaterial(pathoutline1);
  
    local pathoutline2 = venuscore.IFileSystem:PathAssembly("docs:/material/outline2.material");  
    --self.outline2 = host:CreateRenderObject(pathoutline2);
    self.outline2 = host:CreateMaterial(pathoutline2);
  
    local pathcomic = venuscore.IFileSystem:PathAssembly("docs:/material/comic.material");  
    --self.comic = host:CreateRenderObject(pathcomic);
    self.comic = host:CreateMaterial(pathcomic);   
    --local pathout3 = venuscore.IFileSystem:PathAssembly("ress:filter/resource/material/pslevel.material");  
    --self.PSLevel = host:CreateRenderObject(pathout3);


    self.dirmapswapRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );

    self.labcolorRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );
    self.dirmapRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_C, size );
    self.disgaussRT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_D, size );

    self.outline1RT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_E, size );
    self.outline2RT = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_F, size );

    --local downsamplesize = mathfunction.vector2(size:x()/4,size:y()/4);

    self:UpdateSize(size)

    return self.Queue;
end

function comic:UpdateSize(size)  -- fortest
    self.height= size:y();
    self.hOffset=1.0/self.height;
    self.width=size:x();
    self.wOffset=1.0/self.width;
    --self.Cartoon:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );

   -- self.Downsample:SetParameter(self.DOWNSAMPLE_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );
end


function comic:Resizeview(size)
    self:UpdateSize(size)
    self.size = size;
end

function comic:Labcolor(context, Original, Scene, Output)
    --self.labcolorRT:PushRenderTarget();
    --self.labcolorRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
    self.labcolor:SetParameter(self.UNIFORM_uGa, mathfunction.vector1(1));  
    self.labcolor:SetParameter(self.TEXTURE_uDab,
        Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) )
		
	self.labcolor:SetParameter(self.TEXTURE_uLut,
        self.preluttex);  
    context:Draw(self.commonQuad,self.labcolor);
    context:EndRenderPass();
end

function comic:Dirmap(context, Original, Scene, Output)
    --self.dirmapRT:PushRenderTarget();
    --self.dirmapRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
   
    
    self.dirmap:SetParameter(self.TEXTURE_Lab,
        self.labcolorRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.dirmap:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.dirmap:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );
    --self.dirmap:Draw(pipeline);
    context:Draw(self.commonQuad,self.dirmap);
    context:EndRenderPass();
    
    -------------------------------------------------------------------------
    --self.dirmapswapRT:PushRenderTarget();
    --self.dirmapswapRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.dirblur:SetParameter(self.TEXTURE_uDab,
        self.dirmapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.dirblur:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.dirblur:SetParameter(self.UNIFORM_uHiu,mathfunction.vector1(8 ) );
    self.dirblur:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );

    --self.dirblur:Draw(pipeline);
    context:Draw(self.commonQuad,self.dirblur);
    context:EndRenderPass();
    -------------------------------------------------------------------------
    --self.dirmapRT:PushRenderTarget();
    --self.dirmapRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
    --Output:PushRenderTarget();
    --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);

    self.dirfinal:SetParameter(self.TEXTURE_uDab,
        self.dirmapswapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.dirfinal:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.dirfinal:SetParameter(self.UNIFORM_uHiu,mathfunction.vector1(8 ) );
    self.dirfinal:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );

    --self.dirfinal:Draw(pipeline);
    context:Draw(self.commonQuad,self.dirfinal);
    context:EndRenderPass();
end


function comic:DisGauss(context, Original, Scene, Output)
    --self.dirmapswapRT:PushRenderTarget();
    --self.dirmapswapRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);

    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.disguass:SetParameter(self.TEXTURE_uBwm,
        self.dirmapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.disguass:SetParameter(self.TEXTURE_uHam,
        self.labcolorRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.disguass:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.disguass:SetParameter(self.UNIFORM_uEfa,mathfunction.vector1(72) );
    self.disguass:SetParameter(self.UNIFORM_uWad,mathfunction.vector1(0.0036125) );
    self.disguass:SetParameter(self.UNIFORM_uEds,mathfunction.vector1(0) );
    self.disguass:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );

    --self.disguass:Draw(pipeline);
    context:Draw(self.commonQuad,self.disguass);
    context:EndRenderPass();
    -------------------------------------------------------------------------
    --self.disgaussRT:PushRenderTarget();
    --self.disgaussRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);

    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.disguass:SetParameter(self.TEXTURE_uBwm,
        self.dirmapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.disguass:SetParameter(self.TEXTURE_uHam,
        self.dirmapswapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  

    self.disguass:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.disguass:SetParameter(self.UNIFORM_uEfa,mathfunction.vector1(72) );
    self.disguass:SetParameter(self.UNIFORM_uWad,mathfunction.vector1(0.0036125) );
    self.disguass:SetParameter(self.UNIFORM_uEds,mathfunction.vector1(1) );
    self.disguass:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );

    context:Draw(self.commonQuad,self.disguass);
    context:EndRenderPass();
end

function comic:Outline1(context, Original, Scene, Output)
    --self.outline1RT:PushRenderTarget();
    --self.outline1RT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    --Output:PushRenderTarget();
    --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.outline1:SetParameter(self.TEXTURE_uBwm,
        self.dirmapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.outline1:SetParameter(self.TEXTURE_uHam,
        self.labcolorRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.outline1:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.outline1:SetParameter(self.UNIFORM_uHiu,mathfunction.vector1(4.6818) );
    self.outline1:SetParameter(self.UNIFORM_uTau,mathfunction.vector1(0.007095) );
    self.outline1:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );
	
	self.outline1:SetParameter(self.UNIFORM_uSmooth,mathfunction.vector1(comic.smooth) );

    --self.outline1:Draw(pipeline);
    context:Draw(self.commonQuad,self.outline1);
    context:EndRenderPass();
end

function comic:DisGauss2(context, Original, Scene, Output)
    --self.dirmapswapRT:PushRenderTarget();
    --self.dirmapswapRT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.disguass:SetParameter(self.TEXTURE_uBwm,
        self.dirmapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.disguass:SetParameter(self.TEXTURE_uHam,
        self.disgaussRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.disguass:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.disguass:SetParameter(self.UNIFORM_uEfa,mathfunction.vector1(72) );
    self.disguass:SetParameter(self.UNIFORM_uWad,mathfunction.vector1(0.0036125) );
    self.disguass:SetParameter(self.UNIFORM_uEds,mathfunction.vector1(0) );
    self.disguass:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );
    --self.disguass:Draw(pipeline);
    context:Draw(self.commonQuad,self.disguass);
    context:EndRenderPass();
    -------------------------------------------------------------------------
    --Output:PushRenderTarget();
    --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.disguass:SetParameter(self.TEXTURE_uBwm,
        self.dirmapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.disguass:SetParameter(self.TEXTURE_uHam,
        self.dirmapswapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  

    self.disguass:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.disguass:SetParameter(self.UNIFORM_uEfa,mathfunction.vector1(72) );
    self.disguass:SetParameter(self.UNIFORM_uWad,mathfunction.vector1(0.0036125) );
    self.disguass:SetParameter(self.UNIFORM_uEds,mathfunction.vector1(1) );
    self.disguass:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );

    --self.disguass:Draw(pipeline);
    context:Draw(self.commonQuad,self.disguass);
    context:EndRenderPass();
end


function comic:Outline2(context, Original, Scene, Output)
    --Output:PushRenderTarget();
    --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.outline2:SetParameter(self.TEXTURE_uBwm,
        self.dirmapRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.outline2:SetParameter(self.TEXTURE_uTua,
        self.outline1RT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.outline2:SetParameter(self.UNIFORM_uOs,mathfunction.vector2(1.0/self.width, 1.0/self.height ) );
    self.outline2:SetParameter(self.UNIFORM_uHiu,mathfunction.vector1(200.0) );
    self.outline2:SetParameter(self.UNIFORM_uJhi,mathfunction.vector1(0.728824) );
    self.outline2:SetParameter(self.UNIFORM_uKj,mathfunction.vector1(0.514706) );
    self.outline2:SetParameter(self.UNIFORM_uVer,mathfunction.vector1(2) );

    --self.outline2:Draw(pipeline);
    context:Draw(self.commonQuad,self.outline2);
    context:EndRenderPass();
end

function comic:Comic(context, Original, Scene, Output)
    --self.outline2RT:PushRenderTarget();
    --self.outline2RT:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);

    self.comic:SetParameter(self.TEXTURE_Lab,
        self.disgaussRT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.comic:SetParameter(self.TEXTURE_uLut,
        self.luttex);  
    self.comic:SetParameter(self.TEXTURE_Outline,
        self.outline2RT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));  
    self.comic:SetParameter(self.UNIFORM_uS,mathfunction.vector1(0) );
	
    self.comic:SetParameter(self.UNIFORM_uLop,mathfunction.vector1(comic.uLop) );
	--comic.uOin = 0.0;
    self.comic:SetParameter(self.UNIFORM_uOin,mathfunction.vector1(0.0) );
	self.comic:SetParameter(self.UNIFORM_uSaturantion,mathfunction.vector1(comic.saturation) );
	
    --self.comic:Draw(pipeline);
    context:Draw(self.commonQuad,self.comic);
    context:EndRenderPass();
end

function comic:Process(context, Original, Scene, Output)
    self:Labcolor(context, Original, Scene, Output);
    self:Dirmap(context, Original, Scene, Output);
    self:DisGauss(context, Original, Scene, Output);
    self:Outline1(context, Original, Scene, Output);
    self:DisGauss2(context, Original, Scene, Output);
    self:Outline2(context, Original, Scene, Output);
    self:Comic(context, Original, Scene, Output);
end

return comic;

