#SHADER_DEFINE FacechangeSoftlightVertex

 FUNCTION_INPUT = 
 {
  { ATTRIBUTE_POSITION,      HIGH, VEC4,  "in_Position" },
    { ATTRIBUTE_COORDNATE0,   HIGH, VEC2,  "in_TexCooridate"},
    { ATTRIBUTE_COORDNATE2,   HIGH, VEC2,  "in_TexCooridatestd"},
    { UNIFORM_FACETEXPARA,       HIGH, VEC4,  "in_facetexpara" },
 }

 FUNCTION_OUTPUT = 
 {
  
    { ATTRIBUTE_COORDNATE0,   HIGH, VEC2,  "out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,     HIGH,    VEC2,        "out_TexCooridateBag" },
    { ATTRIBUTE_COORDNATE2,   HIGH, VEC2,  "out_TexCooridatestd"},
 }

#SHADER_CODE
    gl_Position =in_Position;
    vec2 out_TexCooridateBag;
    out_TexCooridateBag=(vec2(1.0,1.0)+in_Position.xy)/2.0;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_TexCooridatestd = in_TexCooridatestd.xy*vec2(in_facetexpara.x,in_facetexpara.y)+vec2(in_facetexpara.z,in_facetexpara.w);
#END_CODE
#END_DEFINE


#SHADER_DEFINE FacechangeSoftlightFragment

 FUNCTION_INPUT = 
 {
    { TEXTURE_DIFFUSE,     NONE, TEXTURE2D, "in_Texture" },
    { TEXTURE_BACKG,     NONE, TEXTURE2D, "in_TextureFace" },
    { ATTRIBUTE_COORDNATE0, HIGH, VEC2,    "in_TexC" }, 
    { ATTRIBUTE_COORDNATE1,     HIGH,    VEC2,     "in_TexCooridateBag" },
    { ATTRIBUTE_COORDNATE2,   HIGH, VEC2,  "in_TexCooridatestd"},
    { UNIFORM_ALPHACOF, HIGH, FLOAT,   "in_alpha" },
 }
 
#SHADER_CODE
    vec4 baseColor = texture2D(in_Texture, in_TexCooridateBag);
    vec4 blendColor = vec4(0.0);
    blendColor = texture2D(in_TextureFace, in_TexCooridatestd);
    float r,g,b;
    //blendColor = vec4(0.5);
    if(blendColor.r<0.5)
    {
      r = 2.0*blendColor.r*baseColor.r + baseColor.r*baseColor.r*(1.0-2.0*blendColor.r);
    }
    else
    {
      r =  2.0*baseColor.r*(1.0-blendColor.r) + sqrt(baseColor.r)*(2.0*blendColor.r-1.0); 
    }
    
    if(blendColor.g<0.5)
    {
      g = 2.0*blendColor.g*baseColor.g + baseColor.g*baseColor.g*(1.0-2.0*blendColor.g);
    }
    else
    {
      g =  2.0*baseColor.g*(1.0-blendColor.g) + sqrt(baseColor.g)*(2.0*blendColor.g-1.0);
    }
    
    if(blendColor.b<0.5)
    {
      b = 2.0*blendColor.b*baseColor.b + baseColor.b*baseColor.b*(1.0-2.0*blendColor.b);
    }
    else
    {
      b =  2.0*baseColor.b*(1.0-blendColor.b) + sqrt(baseColor.b)*(2.0*blendColor.b-1.0);
    }
    blendColor.a = step(max(in_TexCooridatestd.x,in_TexCooridatestd.y),0.95)*blendColor.a*step(0.05,min(in_TexCooridatestd.x,in_TexCooridatestd.y));
    gl_FragColor = vec4(vec3(clamp(r,0.0,1.0),clamp(g,0.0,1.0),clamp(b,0.0,1.0)),blendColor.a*in_alpha);
    
#END_CODE
#END_DEFINE