
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
TEXTURE_BACKG = { "Background RGB Tex", TEXTURE2D, "white" },
TEXTURE_BACKG_ALPHA = { "Background Alpha Tex", TEXTURE2D, "white" },
UNIFORM_FACETEXPARA = { "FaceTex Params", VEC4, "1.0,1.0,0.0,0.0"},
#END

#DEFTAG
ShaderName = "facechangecolordodge_split"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float2 uvstd : TEXCOORD2;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 texCoord : TEXCOORD0;
	float2 texCoordBag : TEXCOORD1;
	float2 texCoordStd : TEXCOORD2;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_BACKG_RGB;
Texture2D TEXTURE_BACKG_ALPHA;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_BACKG_RGB_Sampler;
SamplerState TEXTURE_BACKG_ALPHA_Sampler;
float4 UNIFORM_FACETEXPARA;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.texCoord = v.uv;
	float2 flipVertex = float2(v.vertex.x, -v.vertex.y);
	o.texCoordBag = (float2(1.0, 1.0) + flipVertex) / 2.0;
	o.texCoordStd = v.uvstd * float2(UNIFORM_FACETEXPARA.x, UNIFORM_FACETEXPARA.y)
								+ float2(UNIFORM_FACETEXPARA.z, UNIFORM_FACETEXPARA.w);
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 baseColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.texCoordBag);
	float3 blendColorRGB = TEXTURE_BACKG_RGB.Sample(TEXTURE_BACKG_RGB_Sampler, i.texCoordStd).rgb;
    float blendColorAlpha = TEXTURE_BACKG_ALPHA.Sample(TEXTURE_BACKG_ALPHA_Sampler,i.texCoordStd).r;
	float4 blendColor = float4(blendColorRGB, blendColorAlpha);
	
	float3 colorRe = min(baseColor.rgb/(float3(1.0,1.0,1.0)-blendColor.rgb),1.0);
    mainColor = float4(colorRe*(blendColor.a)+(1.0-blendColor.a)*baseColor.rgb, 1.0);
}
ENDCG
#END
