local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local SetParameterCommand = CommandBase:extend("SetParameterCommand");

function SetParameterCommand:new(comuid, smsId, tranId, conId, paramId)
    SetParameterCommand.super.new(self);
    self._comUid = comuid;
    self._smsId = smsId;
    self._tranId = tranId;
    self._conId = conId;
    self._paramId = paramId;
end

function SetParameterCommand:DoIt()
    self:BeginCmd();
    local ani = self:GetContent(self._comUid);
    if ani then
       ani:SetParameterToCondition(self._smsId, self._tranId, self._conId, self._paramId);
    end
    self:EndCmd();
end

function SetParameterCommand:Undo()
    self:BeginCmd();
    
    self:EndCmd();
end

return SetParameterCommand;