local gmm = require "torchutility.gaussianmixturemodel"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local torchutility = require "torchutility.utility"
local dogleg = require "torchutility.dogleg"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Operator = require "torchutility.operator"

local MixGauss = Operator:extend();

function MixGauss:new(gmm,pose)

  MixGauss.super.new(self,pose);
  self.gmm = gmm;
end

  
function MixGauss:Caculate( posev3 )
  local pose = torch.Tensor(1,69);
  for i=1,23 do
    for j=1,3 do
      local poseidx = (i-1)*3+j;
      pose[1][poseidx] = posev3[i][j];
    end
  end
  local bi, bp, blll = self.gmm:MinAPriori(pose);
  return blll;
end

function MixGauss:Derivative(paramv3)
  local pose = torch.Tensor(1,69);
  for i=1,23 do
    for j=1,3 do
      local poseidx = (i-1)*3+j;
      pose[1][poseidx] = paramv3[i][j];
    end
  end
  local dr = self.gmm:dx(pose);
  return dr;
end

return MixGauss

