local Object = require "classic"
local MF = require "mathfunction"
local oneeurofilter_quat = Object:extend();

function oneeurofilter_quat:smoothing_factor(t_e, cutoff)
    local r = 2 * math.pi * cutoff * t_e
    return r / (r + 1);
end

function oneeurofilter_quat:smoothing_quat(a, x, x_prev)
    local dest = MF.Mathutility:Slerp(x_prev, x, a);
    dest:NormalizeSelf();
    return dest;
end

function oneeurofilter_quat:computeDerivativeMagnitude(x)
  return 2.0 * math.acos(x:w())
end

function oneeurofilter_quat:new(t0, x0, min_cutoff, beta, d_cutoff)
    if min_cutoff == nil then
        min_cutoff = 1;
    end
    if beta == nil then
        beta = 0;
    end
    if d_cutoff == nil then
        d_cutoff = 1
    end
    --The parameters.
    self.min_cutoff = min_cutoff;
    self.beta = beta;
    self.d_cutoff = d_cutoff;
    --Previous values.
    self.x_prev = x0;
    self.dx_prev = MF.Quaternion();
    self.t_prev = t0;
end

function oneeurofilter_quat:filter(t, x)
    --dt
    local t_e = t - self.t_prev
    
    local a_d = self:smoothing_factor(t_e, self.d_cutoff)
    local dx = self.x_prev:Inverse() * x;
    local dx_hat = self:smoothing_quat(a_d, dx, self.dx_prev);

    --The filtered signal.
    local cutoff = self.min_cutoff + self.beta * self:computeDerivativeMagnitude(dx_hat)
    local a = self:smoothing_factor(t_e, cutoff)
    local x_hat = self:smoothing_quat(a, x, self.x_prev)
    
    --Save current values.
    self.x_prev = x_hat
    self.dx_prev = dx_hat
    self.t_prev = t

    return x_hat
end

return oneeurofilter_quat;