local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local thresholding = {}
thresholding.material = nil;
thresholding.renderobject = nil;
thresholding.Queue = 100;

function thresholding:Initialize(host, size)
  self.UNIFORM_THRESHOLD =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_THRESHOLD");
  
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/thresholding.material");
  self.material:SetParameter(self.UNIFORM_THRESHOLD, mathfunction.vector1(0.5));
  return self.Queue;
end

function thresholding:Resizeview(size)
end

function thresholding:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return thresholding;

