local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local colorinvertfilter = {}
colorinvertfilter.CilMat = 0;
colorinvertfilter.Queue = 108;



function colorinvertfilter:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"COUNT");  
  self.CilMat = host:CreateMaterial("comm:documents/filter/material/colorinvertfilter.material" );
  self.CilRO = host:CreateRenderObject()
  self.CilMat:SetParameter(self.COUNT, mathfunction.vector1(1.0));
  --self:_SetParam(size);
  return self.Queue;
end

function colorinvertfilter:Resizeview(size)
  --self:_SetParam(size);
end

function colorinvertfilter:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.CilMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
 context:Draw(self.CilRO, self.CilMat);
 context:EndRenderPass();
end

return colorinvertfilter;