local BlueNode = require "bluecore.bluenode"
local BlueUtility = require "bluecore.blueutility"
local BD = require "bluecore.bluedefined"

local GetVariableTemplate = BlueNode:extend();

GetVariableTemplate.myExtend = GetVariableTemplate.extend

function GetVariableTemplate:extend(graph, specDataTbl)

  local clazz = GetVariableTemplate.myExtend(self)

  clazz.graph = graph

  clazz[BD.BaseClass]= "bluecore.variable.getvariable"
  clazz[BD.SpecData] = specDataTbl

  local refVarName = clazz[BD.SpecData][BD.RefVarName]

  clazz:MemberRegister(BD.SpecData)
  clazz:MemberRegister(BD.BaseClass)
  clazz:SetFunctionName("Get "..tostring(refVarName));-- default'name is idName

  assert(refVarName ~= nil, "[GetVariableTemplate] refVarName nil ");

  local varinfo = graph:GetVariableInfo(refVarName);
  if varinfo then
    clazz:_GenerateDataPin(varinfo);
    clazz:SetFunctionName("Get "..varinfo:GetDisplayName());
  elseif _KRATOSEDITOR then
    WARNING("[extend] no rtti info(during deserialization, it's ok)");
  end

  return clazz ;
end

function GetVariableTemplate:_OnDuplicate() -- TODO FIXME(hhl) EditorCreate

  local luaTbl = self[BD.LUA_CLASS_PATH];
  local bluePrintNode = luaTbl(self.graph);
  bluePrintNode[BD.LUA_CLASS_PATH] = luaTbl;
  bluePrintNode:EditorCreate();
  return bluePrintNode;

end


function GetVariableTemplate:GetSpecData()
  return self[BD.SpecData];
end

function GetVariableTemplate:GetTemplateClass()
  return self[BD.BaseClass]
end

function GetVariableTemplate:_GenerateDataPin(varInfo)

  local clazz = self ;

  local refVarName = tostring(clazz[BD.SpecData][BD.RefVarName])

  if _KRATOSEDITOR then
    LOG("[_GenerateDataPin] "..refVarName..":"  .. varInfo.base_rtti:GetTypeName()..","..tostring(varInfo.is_array))
  end

  local rtti = varInfo:GetRtti();
  local displayName = varInfo:GetDisplayName()
  clazz:UnRegisterOutput(1);  -- 清除原来已经注册的
  clazz:RegisterOutput(1, rtti, displayName, "Get "..displayName );

end

function GetVariableTemplate:_OnClassDeserializePost()

  local clazz = self;
  if not next(clazz.infoTable[BD.PIN_DATA_OUTPUT]) then
    local idName = clazz[BD.SpecData][BD.RefVarName]
    if _KRATOSEDITOR then WARNING("[_OnClassDeserializePost] "..tostring(idName)) end
    local varinfo = self.graph:GetVariableInfo(idName);
    if varinfo then
      clazz:_GenerateDataPin(varinfo);
      clazz:SetFunctionName("Get "..tostring(varinfo:GetDisplayName()));
    else
      assert("[_OnClassDeserializePost] no rtti info");
    end
  else
    LOG("[_OnClassDeserializePost] done yet "..tostring( clazz[BD.SpecData][BD.RefVarName]))
  end
end

function GetVariableTemplate:onPropertyChange(publisher, property, oldValue, newValue)
  local clazz = self ;
  if property == BD.VarProp.Name then
    local displayName = tostring(newValue)
    clazz:SetFunctionName("Get "..displayName);
    WARNING("[onPropertyChange] displayName " .. displayName)
  elseif property == BD.VarProp.BaseType then
  elseif property == BD.VarProp.IsArray then
  else
    assert(false, "[onPropertyChange] missing property change ");
  end

  local varinfo = clazz.graph:GetVariableInfo(clazz[BD.SpecData][BD.RefVarName]);
  if varinfo then
    clazz:_GenerateDataPin(varinfo); -- 重新生成数据引脚
  else
    assert("[onPropertyChange] no rtti info");
  end
end


function GetVariableTemplate:_OnDeserialize()
  self[BD.LUA_CLASS_PATH] = getmetatable(self)
  self[BD.SpecData] = nil
end

function GetVariableTemplate:_OnCompile()
  if BD.STRICT_MODE then
    self.compileResult = nil
    local myRtti = self.infoTable[BD.PIN_DATA_OUTPUT][1].rtti
    for _, link in pairs(self.outputs[1].links) do
      local pinInfo = self.graph:GetPinInfoById(link.pinUid);
      local node = self.graph:GetNode(link.nodeUid);
      if not myRtti:isTypeOrDriverType(pinInfo.rtti) then
        local flag = false
        if myRtti:isArray() then
          local compatible = node:IsInputArrayCompatible(pinInfo);
          if compatible then
            local elemType = myRtti:GetElementType();
            flag = elemType:isTypeOrDriverType(pinInfo.rtti) ;
          end
        end
        if not flag then
          self.compileResult = "output pin 1 not match with ".. node:GetName().. " of pin" .. pinInfo.argId
          return false
        end
      end
    end
  end
  return true ;
end

function GetVariableTemplate:GetVariableName()
  return self[BD.SpecData][BD.RefVarName]
end

function GetVariableTemplate:GetRefBluegraph()
  return self.graph -- get/setvariable only use on blueprint itself
end

function GetVariableTemplate:IsVarArrayEd()
  local varInfo = self.graph:GetVariableInfo(self[BD.SpecData][BD.RefVarName]);
  return varInfo:IsArray();
end

---- 游戏运行模式
function GetVariableTemplate:new(...)
  GetVariableTemplate.super.new(self, ...)
end

function GetVariableTemplate:Update(args)
  self.outputResults = {self.graph[self[BD.SpecData][BD.RefVarName]]};
end

function GetVariableTemplate:GetOutputByIndex(index)
  return self.graph[self[BD.SpecData][BD.RefVarName]] ;
end

---- 编辑器模式

if _KRATOSEDITOR then
  function GetVariableTemplate:_OnUpdateByEditor()
    self:_OnCompile() -- 实时做编译/检查
  end
end

GetVariableTemplate:SetFunctionType(BD.VARIABLE_NODE);

GetVariableTemplate:SetFunctionName("Get")

return GetVariableTemplate ;