local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local EXEC_NEXT = 1
local EXEC_RESET = 2

-- ImageSelector + Multigate
local ImageSelector = BlueNode:extend();

---- 游戏运行模式
function ImageSelector:new(...)
  ImageSelector.super.new(self, ...)
  self.execSeq = {}
  self.execIdx = 0
  self.currentIdx = 0
end


function ImageSelector:Update(execIdx)

  if execIdx == nil and self.nextExecNum ~= 0 then
    return
  end

  if execIdx == EXEC_RESET then
    self:_OnReset();
    --return -- reset依旧执行后续 更换图片
  end

  self:_GetInput();

  if _KRATOSEDITOR then
    local BuEd = require "bluecore.editor.blueutility_ed"
    BuEd:BlueDebugYield(self);
  end

  self.outputResults = {self:_OnUpdate(self.inputArgs)};

  return 1;
end

function ImageSelector:_OnUpdate(args)



  local files = args[1] or {}
  local isRandom = args[2]
  local loop = args[3]
  local startIndex =args[4]

  local outNums = #files -- 已经优先排序

  if #self.execSeq == 0 then
    -- 只生成一次
    --WARNING("Generate Exec Seq .. ")
    if startIndex > 0 then
      startIndex = startIndex - 1 -- start from 1 -> 0
    else
      startIndex = 0  -- -1,0 -> 0
    end
    for i = 0, outNums - 1  do
      table.insert(self.execSeq,  ((i + startIndex) % outNums) + 1)
    end
  end

  if loop then

    if self.execIdx == 0 then -- loop end, reset
      if isRandom then
        local half = math.floor(outNums*0.8)
        local offset = math.random(0  ,outNums - half)
        for i = 1, half do
          --math.randomseed(os.time() + i*314159)
          local replace = math.random(1, outNums)
          --WARNING("i "..tostring(i)..", replace "..tostring(replace));
          local old = self.execSeq[i + offset]
          self.execSeq[i + offset] = self.execSeq[replace]
          self.execSeq[replace] = old
        end

        --for i = 1, outNums do
        --  WARNING("i = "..tostring(i)..", "..self.execSeq[i])
        --end

      end
      self.execIdx = 1
    end
    self.currentIdx = self.execSeq[self.execIdx]
    self.execIdx =  self.execIdx < outNums and self.execIdx + 1 or 0 -- 0 end loop
  else
    -- not loop
    if isRandom then
      --math.randomseed(os.time())
      self.currentIdx = math.random(1, outNums)
      self.execIdx = 1 -- never end
    else
      self.currentIdx = self.execSeq[self.execIdx]
      self.execIdx =  self.execIdx < outNums and self.execIdx + 1 or self.execIdx -- 超过就限制在最后一个
    end
  end

  return files[self.currentIdx], outNums, self.currentIdx
end


function ImageSelector:_OnReset()
  self.execIdx = 0
end


---- 编辑器模式

ImageSelector:RegisterInput(1, Types.ImageFileFilterType, "images", "图片集合", {})
ImageSelector:RegisterInput(2, Types.BoolType, "Random", "is random", true);
ImageSelector:RegisterInput(3, Types.BoolType, "Loop", "is loop", false);
ImageSelector:RegisterInput(4, Types.IntType,  "Start Index", "start index", -1);

ImageSelector:RegisterOutput(1, Types.Tex2DPathType, "path", "图片路径")
ImageSelector:RegisterOutput(2, Types.IntType, "total", "图片总数")
ImageSelector:RegisterOutput(3, Types.IntType, "idx", "输出图片索引(从1开始)")

ImageSelector:RegisterExecInput(EXEC_NEXT, "exec", "Execute");
ImageSelector:RegisterExecInput(EXEC_RESET, "reset", "reset", true);
ImageSelector:RegisterExecOutput(1, "exec", "Execute");

ImageSelector:SetFunctionName("Image Selector")

return ImageSelector;

