local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local TriggerNotify = BlueNode:extend();

local likeapp

if not _PLATFORM_WINDOWS then
  likeapp = require "likeapp"
end

---- 游戏运行模式
function TriggerNotify:new(...)
  TriggerNotify.super.new(self, ...)
end

function TriggerNotify:_OnUpdate(args)
  if likeapp then
    likeapp.AI:OnTriggerCB(args[1]);
  else
    -- Windows端如何实现比较好?? 模拟通知客户端
    WARNING("TriggerNotify notify, blocked");
    local libvenuscore = require "libvenuscore"
    local defaultSavePath = libvenuscore.IFileSystem:PathAssembly(SystemDirectories["assets"]);
    libvenuscore.IApplication:GetMainWindow():OpenFileDialog("notify", defaultSavePath);
    libvenuscore.IApplication:GetMainWindow():Update(); -- 挂起 等待
    libvenuscore.IApplication:GetMainWindow():GetSelectedPath(); -- 忽略结果
  end
  return true;
end

---- 编辑器模式
TriggerNotify:RegisterInput(1, Types.IntType, "extra", "附加参数", 0);
TriggerNotify:RegisterExecInput(1, "exec", "执行");
TriggerNotify:RegisterExecOutput(1, "exec", "执行");
TriggerNotify:SetFunctionName("Notify");
TriggerNotify:SetFunctionType(BD.USER_INTERFACE_NODE);


--likeapp.AI:OnTriggerCB(2500);
--local x,y,width,height,ts = likeapp.AI:GetImageCB();
--ERROR("x = "..tostring(x))
--ERROR("y = "..tostring(y))
--ERROR("width = "..tostring(width))
--ERROR("height = "..tostring(height))
--ERROR("ts = "..tostring(ts))
--
--likeapp.AI:PublishImageCB(777,666, 14);

return TriggerNotify ;

