local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"

local Tan = BlueNode:extend();

---- 游戏运行模式
function Tan:new(...)
  Tan.super.new(self, ...)
end

function Tan:_OnUpdate(args)
  
  return math.tan(args[1]), math.tan(args[2]*math.pi/180.0);
  -- pi/2处的无穷大 UE没判断

end

---- 编辑器模式

Tan:RegisterInput(1, Types.FloatType, "pi", "[1]", 0);
Tan:RegisterInput(2, Types.FloatType, "angle", "[2]", 0);
Tan:RegisterOutput(1, Types.FloatType, "tan(pi)", "正切结果(输入弧度)");
Tan:RegisterOutput(2, Types.FloatType, "tan(angle)", "正切结果(输入角度)");
Tan:SetFunctionName("Tan");
Tan:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Tan;

