local BlueDefined = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local NoGreater = BlueNode:extend();

---- 游戏运行模式
function NoGreater:new(...)
  NoGreater.super.new(self, ...)
  self.result = false ;
end

function NoGreater:_OnUpdate(args)
  if args[1] <=  args[2] then
    self.result = true
  else
    self.result = false
  end
  return self.result;
end




---- 编辑器模式


NoGreater:RegisterInput(1, Types.FloatType, "1", "[1]", 0);
NoGreater:RegisterInput(2, Types.FloatType, "2", "[2]", 0);

NoGreater:RegisterOutput(1, Types.BoolType, "<=", "对比结果");

NoGreater:SetFunctionName("<=");
NoGreater:SetFunctionType(BlueDefined.STATIC_FUNCTION_NODE);

return NoGreater;

