local BN = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local AE = require "apolloengine"
local ED = require "bluecore.eventdispatcher"
local Types = require "venuscore.rtti.types"

local RotateGesture = BN:extend();

function RotateGesture:new(...)
  RotateGesture.super.new(self, ...)
end

local BEGIN = AE.SensorsTrackingComponent.VALUE_GESTURE_BEGIN
local KEEP = AE.SensorsTrackingComponent.VALUE_GESTURE_KEEP
local END = AE.SensorsTrackingComponent.VALUE_GESTURE_END

function RotateGesture:_OnUpdate(eventParam)
  local result = eventParam
  local event = result.value -- begin/keep/move
  if event ~= nil then
    if event == BEGIN then
      self.nextExecIdx = 1
      return 0, 0, 0
    elseif event == KEEP then
      local degree = result.z
      local x = result.x
      local y = result.y
      self.nextExecIdx = 2
      return degree, x, y
    elseif event == END then
      self.nextExecIdx = 3
      return 0, 0, 0
    else
      ERROR("[RotateGesture] unknown event "..event);
    end
  end
  self.nextExecIdx = 0 -- break exec
end

function RotateGesture:_OnNextBranch()
  return self.nextExecIdx
end

function RotateGesture:RegisterTriggerFunc(func, bluePrintSelf)

  ED:RegisterCallback(
          BD.Event.GestureRotatePath,
          BD.Event.GestureGlobalEvent.GESTURE_BEGIN,
          func,
          bluePrintSelf);

  ED:RegisterCallback(
          BD.Event.GestureRotatePath,
          BD.Event.GestureGlobalEvent.GESTURE_KEEP,
          func,
          bluePrintSelf);

  ED:RegisterCallback(
          BD.Event.GestureRotatePath,
          BD.Event.GestureGlobalEvent.GESTURE_END,
          func,
          bluePrintSelf);

  AE.IActionSystem:AddClient(
          AE.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_ROTATE,
          bluePrintSelf.Node:GetComponent(AE.Node.CT_BLUEPRINT), 0);
end

function RotateGesture:_OnStop()
  -- ED:RegisterCallback -- Do not Need,blueprint Stop() will unregister all
  AE.IActionSystem:RemoveClient(
          AE.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_ROTATE,
          self.graph.Node:GetComponent(AE.Node.CT_BLUEPRINT));

end


RotateGesture:RegisterOutput(1, Types.FloatType, "degree", "delta, clockwise is positive, degree is valid when 'keep'")
RotateGesture:RegisterOutput(2, Types.FloatType, "x", "rotate center x")
RotateGesture:RegisterOutput(3, Types.FloatType, "y", "rotate center y")

RotateGesture:RegisterExecOutput(1, "begin", "begin to rotate");
RotateGesture:RegisterExecOutput(2, "keep", "keep rotating");
RotateGesture:RegisterExecOutput(3, "stop", "stop rotating");

RotateGesture:SetFunctionName("Rotate Gesture");
RotateGesture:SetFunctionType(BD.EVENT_FUNCTION_NODE);
RotateGesture:SetEventType(BD.EventType.RegisterCallback);

return RotateGesture;
