local BU = require "bluecore.blueutility"
local BlueNode = require "bluecore.bluenode"
local Sequence2 = BlueNode:extend();

function Sequence2:new(...)
  Sequence2.super.new(self, ...);
end

function Sequence2:Update(_execIdx)
  for i = 1, 2 do
    local nextIdx = self.nextExecIndex[i];
    local nextNode = self.nextExecNodes[i];
    local lastNode = self;
    local execIdx = i;
    if _KRATOSEDITOR then
      local BuEd = require "bluecore.editor.blueutility_ed"
      BuEd:BlueDebugYield(self);
    end
    while nextNode ~= nil
    do
      if _KRATOSEDITOR then
        local link_uid = lastNode.execOutputs[execIdx].links[1].linkUid;
        self.graph:AddExecLinkList(link_uid);
      end
      lastNode = nextNode;
      execIdx = nextNode:Update(nextIdx);
      nextIdx  = nextNode.nextExecIndex[execIdx];
      nextNode = nextNode.nextExecNodes[execIdx];
    end
  end
end

Sequence2:RegisterExecInput(1, "exec", "Execute");

Sequence2:RegisterExecOutput(1, "exec", "Execute");
Sequence2:RegisterExecOutput(2, "exec", "Execute");

Sequence2:SetFunctionName("Sequence2");

return Sequence2;