local BATNode = require "bluecore.base.blue_anytype_node"
local BD = require "bluecore.bluedefined"

local Types = require "venuscore.rtti.types"

local GetArrayLength = BATNode:extend();

---- 游戏运行模式
function GetArrayLength:new(...)
  GetArrayLength.super.new(self, ...)
end

function GetArrayLength:_OnUpdate(args)
  if args[1] == nil then
    ERROR("[GetArrayLength] input is nil")
    return 0 ;
  end
  local array = args[1]
  return #array    -- FIXME(hhl) 如果{}不是数组而是字典??
end

---- 编辑器模式
function GetArrayLength:_OnCreateWithEditor()
  GetArrayLength.super._OnCreateWithEditor(self);
end

GetArrayLength:RegisterInput(1, Types.AnyArrayType, "Array", "通配数组", {}, false, BATNode.DEFAULT_GROUP);
GetArrayLength:RegisterOutput(1, Types.IntType, "Length", "数组的长度", 0, false, nil)

GetArrayLength:SetFunctionName("Length");
GetArrayLength:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return GetArrayLength ;
