


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local SetLocalPosition = BlueNode:extend();

---- 游戏运行模式
function SetLocalPosition:new(...)
  SetLocalPosition.super.new(self, ...)
end

function SetLocalPosition:_OnUpdate(args)
  local transformComponent_target = args[1];
  local vec3f_position = args[2];
  transformComponent_target:SetLocalPosition(vec3f_position);
  return true;
end



---- 编辑器模式



SetLocalPosition:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
SetLocalPosition:RegisterInput(2, mathfunction.vector3:RTTI(), "position", "设置target在模型坐标系下的位置", mathfunction.vector3(1.0,1.0,1.0));

SetLocalPosition:RegisterOutput(1, Types.BoolType, "result", "设置成功返回true");

SetLocalPosition:RegisterExecInput(1, "exec", "执行");

SetLocalPosition:RegisterExecOutput(1, "exec", "执行");

SetLocalPosition:SetFunctionName("SetLocalPosition");


return SetLocalPosition ;

