local AE = require "apolloengine"
local MF = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local SetWorldRotation = BlueNode:extend();

function SetWorldRotation:new(...)
  SetWorldRotation.super.new(self,...)
end

function SetWorldRotation:_OnUpdate(args)
  local comp = args[1];
  local qua = args[2];
  comp:SetWorldRotation(qua);
end

SetWorldRotation:RegisterInput(1, AE.TransformComponent:RTTI(), "target", "node", BlueSelf());
SetWorldRotation:RegisterInput(2, MF.Quaternion:RTTI(), "rotation", "设置target的姿态(世界)", MF.Quaternion());

SetWorldRotation:RegisterExecInput(1, "exec", "执行");
SetWorldRotation:RegisterExecOutput(1, "exec", "执行");

SetWorldRotation:SetFunctionName("Set World Rotation");

return SetWorldRotation;
