
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"


local GetWorldRotation = BlueNode:extend();

---- 游戏运行模式
function GetWorldRotation:new(...)
  GetWorldRotation.super.new(self, ...)
end

function GetWorldRotation:_OnUpdate(args)
  return args[1]:GetWorldRotation();
end



---- 编辑器模式

GetWorldRotation:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
GetWorldRotation:RegisterOutput(1, mathfunction.Quaternion:RTTI(), "rotation", "世界旋转");

GetWorldRotation:SetFunctionName("GetWorldRotation");


return GetWorldRotation ;

