

local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local SetColor = BlueNode:extend();

---- 游戏运行模式
function SetColor:new(...)
  SetColor.super.new(self, ...)
end

function SetColor:_OnUpdate(args)
  local thiz = args[1];
  local arg1 = args[2];
  thiz:SetColor(arg1);
  return true;
end

---- 编辑器模式

SetColor:RegisterInput(1, apolloengine.LightComponent:RTTI(), "target", "LightComponent组件", BlueSelf());
SetColor:RegisterInput(2, mathfunction.vector3:RTTI(), "color", "设置灯光颜色", mathfunction.vector3(1.0,1.0,1.0));

SetColor:RegisterOutput(1, Types.BoolType, "result", "设置成功返回true");

SetColor:RegisterExecInput(1, "exec", "执行");

SetColor:RegisterExecOutput(1, "exec", "执行");

SetColor:SetFunctionName("SetColor");


return SetColor ;

