local pnp = require "pnpestimates"
local mf = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local SetHeadId = BlueNode:extend();

function SetHeadId:new(...)
  SetHeadId.super.new(self, ...)
end

function SetHeadId:_OnUpdate(args)
  local comp = args[1];
  local id = args[2];
  if id < 0 then
    id = 0
  end
  if comp ~= nil then
    comp.HeadID = id
  end
end

SetHeadId:RegisterInput(1, pnp.HeadTrackComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
SetHeadId:RegisterInput(2, Types.IntType, "headID", "head id(从0开始)", 0);
SetHeadId:RegisterExecInput(1, "exec", "执行");
SetHeadId:RegisterExecOutput(1, "exec", "执行");
SetHeadId:SetFunctionName("Set Head ID");

return SetHeadId;

