local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local pdenoise = {}
pdenoise.DnMaterial = 0;
pdenoise.DnRenderObj = 0;

pdenoise.Queue = 100;

function pdenoise:_SetParam(size)
  self.height= size:y();
  self.hOffset=1.0/self.height;
  self.width=size:x();
  self.wOffset=1.0/self.width;

  self.DnMaterial:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );
  
end

function pdenoise:Initialize(host, size)
  
 
    --<!--  set the offsets parameters in vertex shader -->
  self.PIXEL_OFFSETS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"PIXEL_OFFSETS");
    
        
  self.SQUARE_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,"SQUARE_COORDNATE"); 

  self.DnMaterial  = host:CreateMaterial("comm:documents/material/denoise.material" );
  self.DnRenderObj = host:CreateRenderObject();
  self:_SetParam(size);
  return self.Queue;
end

function pdenoise:Resizeview(size)
  self:_SetParam(size);
end

function pdenoise:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DnMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.DnRenderObj, self.DnMaterial);
  context:EndRenderPass();
end

return pdenoise;