local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local OutlineCombine = {}
OutlineCombine.DoMaterial = 0;
OutlineCombine.DoRenderObj = 0;
OutlineCombine.Queue = 310;

function OutlineCombine:Initialize(host, size)
  self.prethreshold = mathfunction.vector1(0.0);
  self.threshold = mathfunction.vector1(0.0);
  self.sigma_r = mathfunction.vector1(0.0);
  self.SourceTex = apolloengine.TextureEntity();

  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");
  self.PRETHRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "PRETHRESHOLD");
  self.THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "THRESHOLD");
  self.SIGMA_R = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SIGMA_R");

  self.TEXTURE_DIFFUSE2 = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TEXTURE_DIFFUSE2");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/outline_combine.material");
  self.DoMaterial = host:CreateMaterial(pathout);
  self.DoRenderObj = host:CreateRenderObject();

  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
  self.DoMaterial:SetParameter(self.PRETHRESHOLD, self.prethreshold);
  self.DoMaterial:SetParameter(self.SIGMA_R, self.sigma_r);
  self.DoMaterial:SetParameter(self.TEXTURE_DIFFUSE2, self.SourceTex);
  self.DoMaterial:SetParameter(self.THRESHOLD, self.threshold);

  host:RegisterScriptParameter(self,"prethreshold");
  host:RegisterScriptParameter(self,"threshold");
  host:RegisterScriptParameter(self,"sigma_r");
  host:RegisterScriptParameter(self, "SourceTex");
  return self.Queue;
end



function OutlineCombine:Resizeview(size)
  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
end

function OutlineCombine:Process(context, Original, Scene, Output)

  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.DoMaterial:SetParameter(self.PRETHRESHOLD, self.prethreshold);
  self.DoMaterial:SetParameter(self.SIGMA_R, self.sigma_r);
  self.DoMaterial:SetParameter(self.TEXTURE_DIFFUSE2, self.SourceTex);
  self.DoMaterial:SetParameter(self.THRESHOLD, self.threshold);
  context:Draw(self.DoRenderObj, self.DoMaterial);
  context:EndRenderPass();	
end

return OutlineCombine;