require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local normal = {}

normal.renderObject = nil;
normal.material = nil;
normal.queue = 100;
normal.blendtex = nil;

function normal:Initialize(host, size)
  local preTexPath = "comm:documents/texture/posteffect/lutpv.png";
  self.blendtex = apolloengine.TextureEntity();
  self.blendtex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        preTexPath));
  self.blendtex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.blendtex:CreateResource();
  self.TEXTURE_BLEND = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_BLEND");
  --self.renderObject = host:CreateRenderObject("comm:documents/material/blend_normal.material");
  self.material = host:CreateMaterial("comm:documents/material/blend_normal.material");
  self.renderObject = host:CreateRenderObject();

  host:RegisterScriptParameter(self,"blendtex");
  return self.queue;
end

function normal:Resizeview(size)

end

function normal:Process(context, Original, Scene, Output)
  --Output:PushRenderTarget();
  --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
        
  self:UpdateParameters();
  
  --self.renderObject:Draw(pipeline);
  context:Draw(self.renderObject, self.material);
  context:EndRenderPass();
end

function normal:UpdateParameters()
  if self.blendtex ~= nil then
    --self.renderObject:SetParameter(self.TEXTURE_BLEND, self.blendtex);
    self.material:SetParameter(self.TEXTURE_BLEND, self.blendtex);
  end
end

return normal;