--local apolloengine = require "apolloengine"
local cv = require "computervisionfunction"
local DeviceResource = require "apolloengine.deviceresource"

local _nativeUpdate = cv.SegmentComponent.Update;
local _nativeStart = cv.SegmentComponent.Start;

local StartFoo = function(self)

  local tex = self:GetMask();
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_SEGMENT, tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_LEFT_BROW, tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_RIGHT_BROW, tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_LEFT_EYE, tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_RIGHT_EYE, tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_NOSE, tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_EXT_MOUTH,tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_INT_MOUTH, tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_LIP, tex);
  DeviceResource:PushDeviceResource(DeviceResource.DEVICE_FACEPARSE_HEAD, tex);

  _nativeStart(self);   -- it may call first
end


local UpdateFoo = function (self,dt)
  if not self:isStarted() then
    self:Start();
  end
  _nativeUpdate(self, dt);
end

--此处必须用rawset，否则会把UPDATE函数设置到cv.SegmentComponent的元表的UPDATE中。
rawset(cv.SegmentComponent,"Update",UpdateFoo)
rawset(cv.SegmentComponent,"Start", StartFoo)
