//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////

#SHADER_DEFINE BlitFragment

	FUNCTION_INPUT =
	{
    { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,   "in_Coordinate" },
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
	}
	FUNCTION_OUTPUT =
	{
    { SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE

    vec4 out_SurfaceColor = texture2D( in_DiffuseTexture, in_Coordinate );
#END_CODE
#END_DEFINE


#SHADER_DEFINE SupermeCombineFragment

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_COORDNATE0,		MEDIUM,		VEC2,			"in_Coordinate" },
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
    { TEXTURE_BLUR1,		NONE,	TEXTURE2D,		"in_BlurTexture1" },
    { TEXTURE_BLUR2,		NONE,	TEXTURE2D,		"in_BlurTexture2" },
    { TEXTURE_BLUR3,		NONE,	TEXTURE2D,		"in_BlurTexture3" },
	}
	FUNCTION_OUTPUT =
	{
    { SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE

    vec4 blurColor = texture2D( in_DiffuseTexture, in_Coordinate );
    vec4 color = texture2D( in_BlurTexture1, in_Coordinate );
    blurColor = color*vec4(0.5) + blurColor;
    color = texture2D( in_BlurTexture2, in_Coordinate );
    blurColor = color*vec4(0.25) + blurColor;
    color = texture2D( in_BlurTexture3, in_Coordinate );
    blurColor = color*vec4(0.125) + blurColor;

    vec4 out_SurfaceColor = blurColor;

#END_CODE
#END_DEFINE


#SHADER_DEFINE SupermeBloomFragment

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_COORDNATE0,		MEDIUM,		VEC2,			"in_Coordinate" },
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
    { TEXTURE_BLOOM,		NONE,	TEXTURE2D,		"in_BloomTex" },
    { BLOOM_PARAM,		  MEDIUM,	FLOAT,		"bloomParam" },
    { MAXLUMINANCE,     MEDIUM,	VEC2,		"in_MaxLuminance" },
	}
	FUNCTION_OUTPUT =
	{
    { SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}

#SHADER_CODE
    vec4 out_SurfaceColor;

    vec4 bloomColor = texture2D( in_BloomTex, in_Coordinate);
    vec4 bloomI;
    bloomI.xyz = bloomColor.xyz;

    vec4 mainColor = texture2D( in_DiffuseTexture, in_Coordinate );
    mainColor = max(mainColor, vec4(0.0, 0.0, 0.0, 0.0) );
    bloomI.xyz = bloomI.xyz*vec3(bloomParam) + mainColor.xyz;

    out_SurfaceColor.w = mainColor.w;
    out_SurfaceColor.xyz = min(bloomI.xyz, vec3(1.0, 1.0, 1.0));

#END_CODE
#END_DEFINE
