

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" },
AMOUNT = { "Amount", FLOAT, "5.0"},
COMPLEXITY = { "Complexity", FLOAT, "5.0"},
SIZE = { "Size", FLOAT, "1.0"},
OFFSET = { "Offset", VEC2, "0.0,0.0"},
EVOLUTION = { "Evolution", FLOAT, "0.0"},
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "turbulentdisplace"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float4 vertex : SV_POSITION;
    float2 uv : TEXCOORD0;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float AMOUNT;
float COMPLEXITY;
float SIZE;
float2 OFFSET;
float EVOLUTION;

void FAST32_hash_2D( float2 gridcell, out float4 hash_0, out float4 hash_1 )	//	generates 2 random numbers for each of the 4 cell corners
{
    //    gridcell is assumed to be an integer coordinate
    const float2 OFFSET = float2( 26.0, 161.0 );
    const float DOMAIN = 71.0;
    const float2 SOMELARGEFLOATS = float2( 951.135664, 642.949883 );
    float4 P = float4( gridcell.xy, gridcell.xy + 1.0 );
    P = P - floor(P * ( 1.0 / DOMAIN )) * DOMAIN;
    P += OFFSET.xyxy;
    P *= P;
    P = P.xzxz * P.yyww;
    hash_0 = frac( P * ( 1.0 / SOMELARGEFLOATS.x ) );
    hash_1 = frac( P * ( 1.0 / SOMELARGEFLOATS.y ) );
}

float2 Interpolation_C2( float2 x )
{
    return x * x * x * (x * (x * 6.0 - 15.0) + 10.0);
}

float Perlin2D( float2 P )
{
    //	establish our grid cell and unit position
    float2 Pi = floor(P);
    float4 Pf_Pfmin1 = P.xyxy - float4( Pi, Pi + 1.0 );

    //	calculate the hash.
    float4 hash_x, hash_y;
    FAST32_hash_2D( Pi, hash_x, hash_y );

    //	calculate the gradient results
    float4 grad_x = hash_x - 0.49999;
    float4 grad_y = hash_y - 0.49999;
    float4 grad_results = rsqrt( grad_x * grad_x + grad_y * grad_y ) * ( grad_x * Pf_Pfmin1.xzxz + grad_y * Pf_Pfmin1.yyww );

    grad_results *= 1.4142135623730950488016887242097;		//	(optionally) scale things to a strict -1.0->1.0 range    *= 1.0/sqrt(0.5)
    float2 blend = Interpolation_C2( Pf_Pfmin1.xy );
    float2 res0 = lerp( grad_results.xy, grad_results.zw, blend.y );
    return lerp( res0.x, res0.y, blend.x );
}
float PerlinNormal(float2 p, float frequency, float amplitude)
{
    float sum = 0;
    for (int i = 0; i < 1; i++)
    {
        float h = 0;
        h = Perlin2D((p + OFFSET.xy + float2(cos(EVOLUTION/180*3.1415926),sin(EVOLUTION/180*3.1415926))) * frequency * COMPLEXITY);
        sum += h*amplitude;
    }
    return sum;
}

float fbm_noise(float2 p, float frequency, float amplitude)
{
    float f = 0.0;
    p = p * 2.0;
    float a = 1.;
    for (int i = 0; i < 3; i++)
    {
        f += a * PerlinNormal(p, frequency, amplitude);
        p = 2.0 * p;
        a /= 2.;
    }
    return f;
}

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv;
    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float h = fbm_noise(i.uv, AMOUNT, SIZE);
    float4 texColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv + float2(h,h));

    #ifdef POST_EFFECT_ALPHA_OFF
        mainColor = float4(texColor.xyz,1.0);
    #elif POST_EFFECT_ALPHA_ON
        mainColor = texColor;
    #endif
}
ENDCG
#END
