
#SHADER_DEFINE reflectionVertex
	
	FUNCTION_INPUT = 
	{
		{ATTRIBUTE_POSITION, HIGH, VEC4, "in_Position"},
		{ATTRIBUTE_NORMAL, HIGH, VEC3, "in_Normal"},
		{LOCALWORLD_TRANSFORM, HIGH, MAT4, "in_Transfrom" },
		{CAMERA_VIEWPROJ, HIGH,	MAT4, "in_ViewPorj" },
		{LOCALWORLD_ROTATION,HIGH, MAT3,"in_WorldRotation" },
    { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
	}

	FUNCTION_OUTPUT =
	{
		{ WORLDSPACE_POSITION, HIGH, VEC4, "out_PositionWS" },
		{ WORLDSPACE_NORMAL, HIGH, VEC3, "out_Normal" },
    { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"Out_Coordinate" },
	}

#SHADER_CODE
	gl_Position = in_ViewPorj * in_Transfrom * in_Position;
	vec4 out_PositionWS = in_Transfrom * in_Position;
	vec3 out_Normal = in_WorldRotation * in_Normal;
  mediump vec2 Out_Coordinate = in_Coordinate;

#END_CODE
#END_DEFINE

#SHADER_DEFINE reflectionFragment


	FUNCTION_INPUT =
	{
		{ WORLDSPACE_POSITION, HIGH, VEC4, "out_PositionWS" },
		{ WORLDSPACE_NORMAL, HIGH, VEC3, "out_Normal" },
		{ CAMERA_WORLDPOSITION,HIGH,VEC3, "in_WorldCamPos" },
		{ TEXTURE_REFLECTION, NONE, TEXTURE2D, "in_ReflectionTexture" },
   	{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
		{ ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
    { UNIFORM_REFFACTOR, HIGH, FLOAT, "in_Reffactor"},
		--{ SKY_BOX, NONE, TEXTURECUBE, "in_ReflectionTexture" },
	}

	FUNCTION_OUTPUT =
	{
		{ SURFACE_COLOR, LOW, VEC4,	"out_SurfaceColor" },
	}

#SHADER_CODE
	vec3 viewDir = normalize(vec3(out_PositionWS.xyz) - in_WorldCamPos);
	vec3 reflectDir = reflect(viewDir, normalize(out_Normal));
	vec4 color = texture2D(in_ReflectionTexture, reflectDir.xy)*in_Reffactor;
	color.a = 0.0;
  vec4 color2 = texture2D(in_DiffuseTexture, in_Coordinate)+color;
	gl_FragColor = color2;

#END_CODE
#END_DEFINE




