
#SHADER_DEFINE FXAAVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    vec2 out_TexCooridate = in_TexCooridate.xy;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE


#SHADER_DEFINE FXAAFragment

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    	{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"tex" },
    	{ FXAA_REDUCE_MIN,		HIGH,	FLOAT,		"fxaa_reduce_min" },
    	{ FXAA_REDUCE_MUL,		HIGH,	FLOAT,		"fxaa_reduce_mul" },
    	{ FXAA_SPAN_MAX,		HIGH,	FLOAT,		"fxaa_reduce_max" },
    	{ PIXEL_OFFSETS,            MEDIUM, VEC2,   "in_Offsets"},
    
	}
  
 
  
#SHADER_CODE



	//optimized version for mobile, where dependent 
	//texture reads can be a bottleneck
    vec2 v_rgbNW = textureCoordinate + vec2(-1.0, -1.0) * in_Offsets;
	vec2 v_rgbNE = textureCoordinate + vec2(1.0, -1.0) * in_Offsets;
	vec2 v_rgbSW = textureCoordinate + vec2(-1.0, 1.0) * in_Offsets;
	vec2 v_rgbSE = textureCoordinate + vec2(1.0, 1.0) * in_Offsets;
	vec2 v_rgbM = vec2(textureCoordinate);
    vec3 rgbNW = texture2D(tex, v_rgbNW).xyz;
    vec3 rgbNE = texture2D(tex, v_rgbNE).xyz;
    vec3 rgbSW = texture2D(tex, v_rgbSW).xyz;
    vec3 rgbSE = texture2D(tex, v_rgbSE).xyz;
    vec4 texColor = texture2D(tex, v_rgbM);
    vec3 rgbM  = texColor.xyz;
    vec3 luma = vec3(0.299, 0.587, 0.114);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);
    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
    
    mediump vec2 dir;
    dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
    dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
    
    float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) *
                          (0.25 * fxaa_reduce_mul), fxaa_reduce_min);
    
    float rcpDirMin = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);
    dir = min(vec2(fxaa_reduce_max, fxaa_reduce_max),
              max(vec2(-fxaa_reduce_max, -fxaa_reduce_max),
              dir * rcpDirMin)) * in_Offsets;
    
    vec3 rgbA = 0.5 * (
        texture2D(tex, textureCoordinate  + dir * (1.0 / 3.0 - 0.5)).xyz +
        texture2D(tex, textureCoordinate  + dir * (2.0 / 3.0 - 0.5)).xyz);
    vec3 rgbB = rgbA * 0.5 + 0.25 * (
        texture2D(tex, textureCoordinate  + dir * -0.5).xyz +
        texture2D(tex, textureCoordinate  + dir * 0.5).xyz);

    float lumaB = dot(rgbB, luma);
    //if ((lumaB < lumaMin) || (lumaB > lumaMax))
    //    gl_FragColor = vec4(rgbA, texColor.a);
    //else
    //    gl_FragColor = vec4(rgbB, texColor.a);
    gl_FragColor = step(lumaMin,lumaB)*step(lumaB,lumaMax)*vec4(rgbB, texColor.a)+(1.0-step(lumaMin,lumaB)*step(lumaB,lumaMax))*vec4(rgbA, texColor.a);

  
#END_CODE
#END_DEFINE
