

#DEFPARAMS
TEXTURE_DIFFUSE = { "tex", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "Skeleton1B_2d"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGB
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 position : POSITION;
	float2 uv : TEXCOORD0;
	float4 BoneIndex : BLENDINDICES;
	float4 Boneweight : BLENDWEIGHT;
};

struct v2f
{
	float4 position : SV_POSITION;
	float2 uv : TEXCOORD0;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float3x3 LOCALWORLD_ROTATION;

v2f vert(appdata v)
{
	v2f o;

	o.uv = v.uv.xy;

	float3 blendPos = float3(0.0, 0.0, 0.0);

	for (int bone = 0; bone < 1; ++bone)
	{
		int idx = int(v.BoneIndex[bone]) * 3;

		float weight = v.Boneweight[bone];

		float4x4 worldMatrix =
		{
			ANIMATION_MATRIX_ARRAY[idx],
			ANIMATION_MATRIX_ARRAY[idx + 1],
			ANIMATION_MATRIX_ARRAY[idx + 2],
			float4(0.0,0.0,0.0,0.0)
		};

		blendPos += mul(v.position, worldMatrix).xyz * weight;
	}

	o.position = float4(blendPos,1.0);
	o.position = UniformNDC(o.position);

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
}
ENDCG
#END
