

#DEFPARAMS
TEXTURE_DIFFUSE = { "Texture Diffuse", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "imageblitlzc"
RenderQueue = "Background"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_SAMPLER;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
    float4 col = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, i.uv);
	col.xyz = max(1.055 * pow(col.xyz, 0.416666667) - 0.055, 0.);
    outColor = col;
}
ENDCG
#END
