

#DEFPARAMS
#END

#DEFTAG
ShaderName = "BrightenOverlay"
RenderQueue = "Opaque"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_BLEND;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_BLEND_Sampler;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float3 w = float3(0.2125,0.7154,0.0721);
    float3 basecolor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv).rgb;
    float3 blendcolor = TEXTURE_BLEND.Sample(TEXTURE_BLEND_Sampler,  i.uv).rgb;
    float l = dot(basecolor,w);
    float3 rgb = (l < 0.5)? (2.0 * basecolor * blendcolor) : (float3(1.0,1.0,1.0) - 2.0*(float3(1.0,1.0,1.0) - basecolor)*(float3(1.0,1.0,1.0) - blendcolor));
    mainColor = float4(rgb, 1.0);
}
ENDCG
#END

#DEFPASS PostEffect
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { UNIVERSAL_POST_EFFECT }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_BLEND;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_BLEND_Sampler;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float3 w = float3(0.2125,0.7154,0.0721);
    float3 basecolor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv).rgb;
    float3 blendcolor = TEXTURE_BLEND.Sample(TEXTURE_BLEND_Sampler,  i.uv).rgb;
    float l = dot(basecolor,w);
    float3 rgb = (l < 0.5)? (2.0 * basecolor * blendcolor) : (float3(1.0,1.0,1.0) - 2.0*(float3(1.0,1.0,1.0) - basecolor)*(float3(1.0,1.0,1.0) - blendcolor));
    mainColor = float4(rgb, 1.0);
}
ENDCG
#END