

#DEFPARAMS
#END

#DEFTAG
ShaderName = "backgroundblit"
RenderQueue = "Background"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM

#define USE_GLES_FBF_DEFERRED (VENUS_MRT_FRAMEBUFFER_FETCH && (SHADER_API_GLES || SHADER_API_GLES3))
#define USE_PLS_DEFERRED (VENUS_MRT_PLS && (SHADER_API_GLES || SHADER_API_GLES3))

#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_mrt_fbfetch
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};

struct GBufferOutput
{
     float4 GBufferA : SV_Target0;
     float4 GBufferB : SV_Target1;
     float4 GBufferC : SV_Target2;
     float4 GBufferD : SV_Target3;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}

#if USE_PLS_DEFERRED

void frag(in v2f i)
{
  float4 GBufferA = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
  GLFramebufferFetchWrite0(GBufferA);
}

#else
GBufferOutput frag(in v2f i)
{
    GBufferOutput gbufferOutput;
    gbufferOutput.GBufferA = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
    gbufferOutput.GBufferB = float4(1.0, 1.0, 1.0, 1.0);
    gbufferOutput.GBufferC = float4(1.0, 1.0, 1.0, 1.0);
    gbufferOutput.GBufferD = float4(1.0, 1.0, 1.0, 1.0);

    return gbufferOutput;
}
#endif

ENDCG
#END
