#SHADER_DEFINE ThresholdingVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    
#END_CODE
#END_DEFINE

#SHADER_DEFINE ThresholdingFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    { UNIFORM_THRESHOLD,	HIGH,	FLOAT,		"threshold"},
	}
  
#SHADER_CODE
   vec3 W = vec3(0.2125, 0.7154, 0.0721);
   vec3 rgb = texture2D(uniCurrentTexture,textureCoordinate).rgb;
   float luminance = dot(rgb, W);
   float thresholdResult = step(threshold, luminance);
   gl_FragColor = vec4(vec3(thresholdResult), 1.0);

#END_CODE
#END_DEFINE
   