

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
BOLD = {"bold", FLOATRANGE, "0.0, 0.3, -0.3"},
OUTLINE = {"outline", FLOAT, "0.0"},
TEXTCOLOR = {"Text Color", COLOR, "0.0, 0.0, 0.0, 1.0"},
OUTLINECOLOR = {"Outline Color", COLOR, "0.0, 0.0, 0.0, 1.0"},
[Keywords(HALO_ON, HALO_OFF)]
HALO = {"halo", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "realtimesdf2d"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile HALO_ON HALO_OFF
#include "light.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float BOLD;
float OUTLINE;
float4 TEXTCOLOR;
float4 OUTLINECOLOR;

v2f vert(appdata v)
{
    v2f o; 
    float2 in_WorldScale =mul(float4(1.0,1.0,1.0,1.0), LOCALWORLD_TRANSFORM).xy;
    float2 in_WorldPosition = WORLD_POSITION.xy;
    float4 pos = float4(v.vertex * in_WorldScale * CAMERA_RESOLUTION_INV + in_WorldPosition.xy * CAMERA_RESOLUTION_HALF_INV,0.0,1.0);
    o.vertex = UniformNDC(pos);
    o.uv = v.uv.xy;
    return o;
}

float outline(float distance, float smoothing, float weight)
{
    float textAlpha = smoothstep(0.5 + weight - smoothing, 0.5 + weight + smoothing, distance);
    float outlineAlpha = smoothstep(0.5 - weight - smoothing, 0.5 - weight + smoothing, distance);
    return outlineAlpha - textAlpha;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float distance = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv).a;
    float dx = ddx(i.uv.x) * 2048;
    float dy = ddy(i.uv.y) * 2048;
    float smoothing = 0.02 * sqrt(dx * dx + dy * dy);

    #ifdef HALO_OFF
        float bold = clamp(0.5 - BOLD, smoothing, 1 - smoothing);
        float outline = clamp(bold - OUTLINE, smoothing, 1 - smoothing);
        float textAlpha = smoothstep(bold - smoothing, bold + smoothing, distance);
        float outlineAlpha = smoothstep(outline - smoothing, outline + smoothing, distance);
        float4 color = TEXTCOLOR * textAlpha + OUTLINECOLOR * (outlineAlpha - textAlpha);
    #elif HALO_ON
        float textAlpha = outline(distance, smoothing, BOLD);
        float haloAlpha = 1.0 - abs(distance * 2.0 - 1.0);
        float4 color = TEXTCOLOR * textAlpha + OUTLINECOLOR * clamp(haloAlpha - textAlpha, 0, 1);
    #endif

    mainColor = color;
}
ENDCG
#END
