local Object = require "classic"
local cnnseg = Object:extend();
local mathfunction = require "mathfunction"
--local mlcnnseg = require "likeapp"
local videodefined = require"videodecet.defined"
local apolloengine = require "apolloengine"
local videodetect = require "videodecet.videodecet"
local vc = require "venuscore"
local maskOutW = 128;
local mlcnnseg =nil;
local CnnSegShell = nil;
function cnnseg:SetCnnSegShell()
  --if _PLATFORM_WINDOWS then
   --    mlcnnseg = require "mlcnnseg"
   --    CnnSegShell =mlcnnseg.CnnSegShell;
  --else
      mlcnnseg = require "machinelearningservice"
      CnnSegShell =mlcnnseg.MachinelearningService;
 -- end
 
end

function cnnseg:new()
  --LOG("zgz 1");
  self.cnnSegMark = false;
  self:initPara();
  self:SetCnnSegShell();
end
function cnnseg:initPara()
  --LOG("zgz 2");
  self.w = 0;
  self.h = 0;
  self.cnnsegInit = false;
  self.cnnsegtexture = nil;
  self.cnnsegts = nil;
  self.lastdef = 0;
 -- self.cnnSegMark = false;
end

function cnnseg:InitCnnSeg( w, h)
  --LOG("zgz 3");
  if( mlcnnseg==nil or CnnSegShell==nil)
  then 
    return;
  end
  --LOG("zgz 4");
  self:initPara();
  self.cnnseg = CnnSegShell();
  if(self.cnnseg and CnnSegShell.SetType)
  then
    self.cnnseg:SetType(self.segType);
  end

  if _PLATFORM_WINDOWS then  --只有windows需要设置模型路径
    self.cnnseg:SetModelAndParamsWin(
            videodefined.faceSegType.CNNSEG_FULL ,
            vc.IFileSystem:PathAssembly(videodefined.bvt_model_path));
  end
  --self.tsPara=self.cnnseg:GetConstTexStream(4,4,0);
  --self.cnnseg:SetPowerSave(0);
  --LOG("zgz 5");
  local r =self.cnnseg:Init(w,h);
  --self.tsPara=self.cnnseg:GetConstTexStream(4,4,0);

  self.tsPara = apolloengine.TextureStream();
  self.tsPara:SetStreamType(
     mathfunction.vector2(4,1),
     apolloengine.TextureEntity.PF_L8);
  for u=1, 4 do
    self.tsPara:SetPixel(u, 1, mathfunction.vector1(0.0));
  end 

  if(r~=videodefined.cnnsegFlag.SUCCESS)
  then
    self.cnnsegInit = false;
    --LOG("zgz 6");
  else
    self.cnnsegInit = true;
    self.w = w;
    self.h = h;
    --LOG("zgz 7");
  end
  
  self.cnnsegtexture = nil;
  --self.cnnsegts = self.cnnseg:GetConstTexStream(w,h,0);
  --local num1,num2=math.modf(h*maskOutW/w/2);
  --self.cnnsegts = self.cnnseg:GetConstTexStream(maskOutW,2*num1,0);
  self.cnnsegts = apolloengine.TextureStream();
  self.cnnsegts:SetStreamType(
     mathfunction.vector2(4,1),
     apolloengine.TextureEntity.PF_L8);
  for u=1, 4 do
    self.cnnsegts:SetPixel(u, 1, mathfunction.vector1(0.0));
  end   
  self.cnnConstStream = self.cnnsegts;
  self.cnnsegtexture = apolloengine.TextureEntity();
  self.cnnsegtexture:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
       self.cnnsegts));
  self.cnnsegtexture:CreateResource();
    
end

function cnnseg:SetType(segType)
    self.segType = segType;
end

function cnnseg:startNewUpdate()
  
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
   --self.lastdef = -1;
   self.newupd = true;
end


function cnnseg:SetCnnSegMark(mark)
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  self.cnnSegMark = mark;
  --self.cnnsegtexture=nil;
  --self.cnnsegts = nil;
end

function cnnseg:OnResizeView(w,h)
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  if(self.w~=w or self.h~=h)
  then
    self.cnnsegInit = false;
    self.cnnseg  = nil;
    --self:InitCnnSeg(w,h);
  end
end

function cnnseg:Update(ts,def)
  
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return nil;
  end
  self:_UpdateCnnSeg(ts,def);
  return self.cnnsegtexture;
end


function cnnseg:_UpdateCnnSeg(ts,def)
   
  if( mlcnnseg==nil or CnnSegShell==nil)
  then
    return;
  end
  
   if(not self.newupd)
   then
     return;
   end
  --[[ if(self.lastdef==def)
   then
     return;
   else
     self.lastdef = def;
   end]]
   
   if(not (self.cnnSegMark and self.cnnsegInit==true))
    then
      --self.cnnsegtexture = nil;
      --self.cnnsegts = nil;
      return;
    end
  local cnnsegts = nil; 
  local inputs = nil;
  inputs = videodetect:GetPixelFacekeypointArray();
  if(ts==nil)
  then
     boxarray = self.cnnseg:Run(inputs,self.tsPara);
     cnnsegts = self.cnnseg:GetMask();
  else
     boxarray = self.cnnseg:Run(inputs,ts);
     cnnsegts = self.cnnseg:GetMask();
  end
  
  if(cnnsegts==nil)
  then
   return;
  end
  self.cnnsegts = cnnsegts;
  self.cnnsegtexture:ChangeTextureBuffer(self.cnnsegts);
  self.newupd = false;
end

return cnnseg;