local venuscore = require "venuscore"
local apolloengine = require "apollocore"
local mathfunction = require "mathfunction"
local apollonode,defined
if not  _KRATOSEDITOR then
  apollonode = require "apolloutility.apollonode"
  defined= require "apolloutility.defiend"
end

local UsrscriptModuleCamera  = venuscore.ActorNode:extend("UsrscriptModuleCamera");

UsrscriptModuleCamera:MemberRegister("scriptPath");

function UsrscriptModuleCamera:new(path)
  self.scriptPath = path;
end

function UsrscriptModuleCamera:Initialize(script,node)

  self.componentList = node.componentList  
  for key,value in pairs(self.componentList)do
    if string.find(key,'Userscript_') == nil and value:GetTypeName() == "CameraComponent" then
      self.oricamera = value;
      local resolution = apolloengine.Framework:GetResolution();
      self.oricamera:ChangeResolution(resolution);
      (self.oricamera).Sequence = defined.editor_camera_default_sequence; 
    end    
  end
   
  self.rt = apolloengine.RenderTargetEntity();--创建一个FBO
  self.rt:PushMetadata(--设置FBO格式
      apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--标记作用，主要用于底层资源共享
        apolloengine.Framework:GetViewport(),
        apolloengine.Framework:GetResolution()));--分辨率
  local depth = self.rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);
  depth:PushMetadata(
    apolloengine.DepthRenderBufferMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      apolloengine.Framework:GetResolution(),
      apolloengine.TextureEntity.PF_DEPTH24_STENCIL8
    ));
  self.tex = self.rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
  self.tex:PushMetadata(--创建纹理
      apolloengine.TextureRenderMetadata(
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,--此处的纹理swap和尺寸必须和rt的相同不然将导致未定义的错误
        apolloengine.Framework:GetResolution()));
  self.rt:CreateResource();
  self.oricamera:AttachRenderTarget(self.rt);
  
  self.quadnode = apollonode.QuadNode();
  self.quadnode:SetShow(true);
  self.quadnode:CreateResource(defined.blit_overlay_material_path,true,false);
  self.quadnode:SetSequence(0);
  self.quadnode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.tex);

end

function UsrscriptModuleCamera:Update(def)
end

function UsrscriptModuleCamera:ReleaseResource()
  self.componentList = nil;
  self.oricamera = nil;
  self.rt = nil;
  self.tex = nil;
  self.quadnode = nil;
end

return UsrscriptModuleCamera;
