local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local soundpalyer = require "soundplayer"
local Object = require "classic"
local physicspaser = require "facecute.physx.physicspaser"

--作为一个独立单元每个识别出来的人头配备一个，这个数据中包含需要管理的3d模型
local headmodels = Object:extend();

function headmodels:new(rootpath)
  self.rootpath = rootpath;
  self.head = apollonode.TransNode();
  self.models = {};
  self.sounds = {};
  self.particles = {};
  self.physicspaser = {};
end

--更新人头位置
function headmodels:SetPosture(position, rotation)
  self.head:SetLocalPosition(position);
  self.head:SetLocalRotation(rotation);
end

function headmodels:LoadModel(file, nodeindex)
  local path = self.rootpath..file
  local model = apollonode.ModelNode();
  model:CreateResource(path);
  model:SetShow(false);
  self.head:AttachNode(model);  
  renderqueue:After(model);
  self.models[nodeindex] = model;
  return model;
end

function headmodels:GetModel(index)
  if index then
    return self.models[index];
  end
  return nil;
end

function headmodels:GetPhysics(index)
  if index then
    return self.physicspaser[index];
  end
  return nil;
end

function headmodels:LoadSound(file, nodeindex)
  local path = self.rootpath..file
  local sound = soundpalyer();
  sound:LoadSound(path);
  self.sounds[nodeindex] = sound;
  return sound;
end

function headmodels:GetSound(index)
  if index then
    return self.sounds[index];
  end
  return nil;
end

function headmodels:LoadParticles(files, nodeindex)
  local list = {};
  for _, file in ipairs(files) do
    local path = self.rootpath..file;
    local emitter = apollonode.ParticleNode();
    emitter:CreateResource(path);
    --renderqueue:Before(emitter); 
    renderqueue:Queue("Sticker",emitter); 
    table.insert(list, emitter);
  end
  self.particles[nodeindex] = list;
  return list;
end

function headmodels:LoadPhysx(filename, nodeindex)
  local path = self.rootpath.. filename;
  local model = self:GetModel(nodeindex);
  
  local paser = physicspaser(path,model,self.head);
  self.physicspaser[nodeindex] = paser;
  return paser
end


function headmodels:UpdateIndex(idx,number)
  if self.number==nil then
    self.number = number;
  end

  if self.number~=number then
    for _, physicspaser in pairs(self.physicspaser) do
      physicspaser:OnHeadIndexChange();
    end
  end
  self.number = number;
end

function headmodels:Reset()
  self.stage = nil;
  for _, particlelist in pairs(self.particles) do
    if particlelist ~= nil then
      for _, emitter in pairs(particlelist) do
        emitter:Reset(); --reset 
      end
    end
  end
  
end


function headmodels:GetParticles(index)
  if index then
    return self.particles[index];
  end
  return nil;
end

function headmodels:SetStage(s)
  self.stage = s
end

function headmodels:GetStage()
  return self.stage;
end

function headmodels:Clear()
    self.head:Destroy();

    for _, eachModel in pairs(self.models) do
        if eachModel ~= nil then
          eachModel:Destroy();
        end
    end

    for _, particlelist in pairs(self.particles) do
      if particlelist ~= nil then
        for _, emitter in pairs(particlelist) do
          if emitter ~= nil then
              emitter:Destroy();
          end
        end
      end
    end

end

return headmodels;

